/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.clone.object;

import de.alpharogroup.copy.object.CopyObjectExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.BeanUtils;

public final class CloneObjectExtensions {
    public static <T> T clone(T object) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        return (T)CloneObjectExtensions.cloneObject(object);
    }

    public static Object cloneObject(Object object) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        if (object == null) {
            return object;
        }
        Object clone = null;
        if (object instanceof Cloneable) {
            clone = CloneObjectExtensions.cloneCloneable(object);
        }
        if (clone == null && object instanceof Serializable) {
            Serializable serializableObject = (Serializable)object;
            clone = CopyObjectExtensions.copySerializedObject((Serializable)serializableObject);
        }
        if (clone == null) {
            clone = CloneObjectExtensions.cloneBean(object);
        }
        return clone;
    }

    public static Object cloneCloneable(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object clone;
        if (object.getClass().isArray()) {
            Class<?> componentType = object.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(object);
                clone = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(clone, length, Array.get(object, length));
                }
            } else {
                clone = ((Object[])object).clone();
            }
            if (clone != null) {
                return clone;
            }
        }
        Class<?> clazz = object.getClass();
        Method cloneMethod = clazz.getDeclaredMethod("clone", new Class[0]);
        cloneMethod.setAccessible(true);
        clone = cloneMethod.invoke(object, (Object[])null);
        return clone;
    }

    public static <T> T cloneBean(T object) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Object clone = BeanUtils.cloneBean(object);
        return (T)clone;
    }

    private CloneObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

