/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.clone.object;

import com.rits.cloning.Cloner;
import de.alpharogroup.clone.object.CloneObjectExtensions;
import de.alpharogroup.copy.object.CopyObjectQuietlyExtensions;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloneObjectQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(CloneObjectQuietlyExtensions.class);

    public static <T> T cloneQuietly(T object) {
        return (T)CloneObjectQuietlyExtensions.cloneObjectQuietly(object);
    }

    public static Object cloneObjectQuietly(Object object) {
        if (object == null) {
            return object;
        }
        Object clone = null;
        if (object instanceof Cloneable) {
            clone = CloneObjectQuietlyExtensions.cloneCloneableQuietly(object);
        }
        if (clone == null && object instanceof Serializable) {
            Serializable serializableObject = (Serializable)object;
            clone = CopyObjectQuietlyExtensions.copySerializedObjectQuietly((Serializable)serializableObject);
        }
        if (clone == null) {
            clone = CloneObjectQuietlyExtensions.cloneBeanQuietly(object);
        }
        if (clone == null) {
            Cloner cloner = new Cloner();
            clone = cloner.deepClone(object);
        }
        if (clone == null) {
            clone = CopyObjectQuietlyExtensions.copyPropertiesQuietly((Object)object);
        }
        return clone;
    }

    public static <T> T cloneBeanQuietly(T object) {
        T clone = null;
        try {
            clone = CloneObjectExtensions.cloneBean(object);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return clone;
    }

    public static Object cloneCloneableQuietly(Object object) {
        Object clone = null;
        try {
            clone = CloneObjectExtensions.cloneCloneable(object);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return clone;
    }

    private CloneObjectQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

