/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.verifier;

import de.alpharogroup.evaluate.object.api.ContractViolation;
import de.alpharogroup.evaluate.object.checkers.EqualsHashCodeAndToStringCheck;
import de.alpharogroup.evaluate.object.enums.VerificationType;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;

public final class ContractVerifier<T> {
    private final Class<T> cls;
    private Function<Class<T>, T> factoryFunction;
    private VerificationType verificationType = VerificationType.EQUALS_HASHCODE_AND_TO_STRING;

    public static <T> ContractVerifier<T> of(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new ContractVerifier<T>(type);
    }

    private ContractVerifier(@NonNull Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        this.cls = cls;
    }

    public Optional<ContractViolation> verify() {
        Optional<ContractViolation> verificationResult = Optional.empty();
        try {
            verificationResult = this.factoryFunction != null ? EqualsHashCodeAndToStringCheck.equalsHashcodeAndToString(this.cls, this.factoryFunction) : EqualsHashCodeAndToStringCheck.equalsHashcodeAndToString(this.cls);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        return verificationResult;
    }

    public ContractVerifier<T> withEqualsHashcodeAndToString() {
        this.verificationType = VerificationType.EQUALS_HASHCODE_AND_TO_STRING;
        return this;
    }

    public ContractVerifier<T> withFactoryFunction(@NonNull Function<Class<T>, T> factoryFunction) {
        if (factoryFunction == null) {
            throw new NullPointerException("factoryFunction is marked non-null but is null");
        }
        this.factoryFunction = factoryFunction;
        return this;
    }
}

