/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.evaluators;

import de.alpharogroup.evaluate.object.checkers.EqualsCheck;

public final class EqualsEvaluator {
    public static <T> boolean evaluateReflexivity(T object) {
        return !EqualsCheck.reflexivity(object).isPresent();
    }

    public static <T> boolean evaluateSymmetric(T object, T anotherObject) {
        return !EqualsCheck.symmetric(object, anotherObject).isPresent();
    }

    public static <T> boolean evaluateTransitivity(T a, T b, T c) {
        return !EqualsCheck.transitivity(a, b, c).isPresent();
    }

    public static <T> boolean evaluateNonNull(T object) {
        return !EqualsCheck.nonNull(object).isPresent();
    }

    public static <T> boolean evaluateConsistency(T object, T anotherObject) {
        return !EqualsCheck.consistency(object, anotherObject).isPresent();
    }

    public static <T> boolean evaluateConsistency(T object, T anotherObject, int iterations) {
        return !EqualsCheck.consistency(object, anotherObject, iterations).isPresent();
    }

    public static <T> boolean evaluateReflexivityAndNonNull(T object) {
        return !EqualsCheck.reflexivityAndNonNull(object).isPresent();
    }

    public static <T> boolean evaluateSymmetricAndConsistency(T object, T anotherObject) {
        return !EqualsCheck.symmetricAndConsistency(object, anotherObject).isPresent();
    }

    public static <T> boolean evaluateReflexivityNonNullSymmetricAndConsistency(T object, T otherObject) {
        return !EqualsCheck.reflexivityNonNullSymmetricAndConsistency(object, otherObject).isPresent();
    }

    public static <T> boolean evaluateReflexivityNonNullSymmetricConsistencyAndTransitivity(T object, T otherObject, T anotherObject) {
        return !EqualsCheck.reflexivityNonNullSymmetricConsistencyAndTransitivity(object, otherObject, anotherObject).isPresent();
    }

    private EqualsEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

