/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.checkers;

import de.alpharogroup.evaluate.object.api.ContractViolation;
import de.alpharogroup.evaluate.object.enums.EqualsContractViolation;
import java.util.Optional;

public final class EqualsCheck {
    public static <T> Optional<ContractViolation> reflexivity(T object) {
        if (object == null) {
            return Optional.of(EqualsContractViolation.REFLEXIVITY_NULL_ARGUMENT);
        }
        if (object.equals(object)) {
            return Optional.empty();
        }
        return Optional.of(EqualsContractViolation.REFLEXIVITY);
    }

    public static <T> Optional<ContractViolation> symmetric(T object, T anotherObject) {
        boolean odd;
        if (object == null || anotherObject == null) {
            return Optional.of(EqualsContractViolation.SYMMETRICITY_NULL_ARGUMENT);
        }
        boolean even = object.equals(anotherObject);
        return even == (odd = anotherObject.equals(object)) ? Optional.empty() : Optional.of(EqualsContractViolation.SYMMETRICITY);
    }

    public static <T> Optional<ContractViolation> transitivity(T a, T b, T c) {
        if (a == null || b == null) {
            return Optional.of(EqualsContractViolation.TRANSITIVITY_NULL_ARGUMENT);
        }
        boolean aEqualsB = a.equals(b);
        boolean bEqualsC = b.equals(c);
        boolean aEqualsC = a.equals(c);
        return aEqualsB && bEqualsC && aEqualsC ? Optional.empty() : Optional.of(EqualsContractViolation.TRANSITIVITY);
    }

    public static <T> Optional<ContractViolation> nonNull(T object) {
        if (object == null) {
            return Optional.of(EqualsContractViolation.NON_NULL_NULL_ARGUMENT);
        }
        boolean result = !object.equals(null);
        return result ? Optional.empty() : Optional.of(EqualsContractViolation.NON_NULL);
    }

    public static <T> Optional<ContractViolation> consistency(T object, T anotherObject) {
        return EqualsCheck.consistency(object, anotherObject, 7);
    }

    public static <T> Optional<ContractViolation> consistency(T object, T anotherObject, int iterations) {
        if (object == null || anotherObject == null) {
            return Optional.of(EqualsContractViolation.CONSISTENCY_NULL_ARGUMENT);
        }
        boolean initialEqualsResult = object.equals(anotherObject);
        for (int i = 0; i < iterations; ++i) {
            boolean currentEqualsResult = object.equals(anotherObject);
            if (initialEqualsResult == currentEqualsResult) continue;
            return Optional.of(EqualsContractViolation.CONSISTENCY);
        }
        return Optional.empty();
    }

    public static <T> Optional<ContractViolation> reflexivityAndNonNull(T object) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivity(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = EqualsCheck.nonNull(object);
        return evaluated;
    }

    public static <T> Optional<ContractViolation> symmetricAndConsistency(T object, T anotherObject) {
        Optional<ContractViolation> evaluated = EqualsCheck.symmetric(object, anotherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = EqualsCheck.consistency(object, anotherObject);
        return evaluated;
    }

    public static <T> Optional<ContractViolation> reflexivityNonNullSymmetricAndConsistency(T object, T otherObject) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityAndNonNull(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = EqualsCheck.symmetricAndConsistency(object, otherObject);
        return evaluated;
    }

    public static <T> Optional<ContractViolation> reflexivityNonNullSymmetricConsistencyAndTransitivity(T object, T otherObject, T anotherObject) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityNonNullSymmetricAndConsistency(otherObject, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = EqualsCheck.transitivity(object, otherObject, anotherObject);
        return evaluated;
    }

    private EqualsCheck() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

