/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.checkers;

import de.alpharogroup.evaluate.object.api.ContractViolation;
import de.alpharogroup.evaluate.object.enums.HashcodeContractViolation;
import java.util.Optional;

public final class HashcodeCheck {
    public static <T> Optional<ContractViolation> consistency(T object) {
        if (object == null) {
            return Optional.of(HashcodeContractViolation.CONSISTENCY_NULL_ARGUMENT);
        }
        boolean equalHashcode = object.hashCode() == object.hashCode();
        return equalHashcode ? Optional.empty() : Optional.of(HashcodeContractViolation.CONSISTENCY);
    }

    public static <T> Optional<ContractViolation> equality(T object, T anotherObject) {
        if (object == null) {
            return Optional.of(HashcodeContractViolation.EQAUALITY_NULL_ARGUMENT);
        }
        if (object.equals(anotherObject)) {
            boolean equalHashcode = object.hashCode() == anotherObject.hashCode();
            return equalHashcode ? Optional.empty() : Optional.of(HashcodeContractViolation.EQAUALITY);
        }
        return Optional.of(HashcodeContractViolation.EQAUALITY);
    }

    public static <T> Optional<ContractViolation> unequality(T object, T anotherObject) {
        if (object == null) {
            return Optional.of(HashcodeContractViolation.UNEQAUALITY_NULL_ARGUMENT);
        }
        if (!object.equals(anotherObject)) {
            boolean unequalHashcode;
            if (anotherObject == null) {
                return Optional.empty();
            }
            boolean bl = unequalHashcode = object.hashCode() != anotherObject.hashCode();
            if (unequalHashcode) {
                return Optional.empty();
            }
        }
        return Optional.of(HashcodeContractViolation.UNEQAUALITY);
    }

    private HashcodeCheck() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

