/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.checkers;

import de.alpharogroup.clone.object.CloneObjectExtensions;
import de.alpharogroup.evaluate.object.api.ContractViolation;
import de.alpharogroup.evaluate.object.checkers.EqualsCheck;
import de.alpharogroup.evaluate.object.checkers.HashcodeCheck;
import de.alpharogroup.evaluate.object.checkers.ToStringCheck;
import de.alpharogroup.evaluate.object.enums.EqualsHashcodeContractViolation;
import de.alpharogroup.evaluate.object.enums.ToStringContractViolation;
import de.alpharogroup.random.RandomObjectFactory;
import io.github.benas.randombeans.EnhancedRandomBuilder;
import io.github.benas.randombeans.api.EnhancedRandom;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;

public final class EqualsHashCodeAndToStringCheck {
    public static <T> Optional<ContractViolation> equalsAndHashcode(T first, T second, T third, T fourth) {
        if (first == null) {
            return Optional.of(EqualsHashcodeContractViolation.FIRST_ARG_NULL);
        }
        if (first.equals(second)) {
            return Optional.of(EqualsHashcodeContractViolation.FIRST_AND_SECOND_EQUAL);
        }
        if (!first.equals(third)) {
            return Optional.of(EqualsHashcodeContractViolation.FIRST_AND_THIRD_UNEQUAL);
        }
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityNonNullSymmetricAndConsistency(first, second);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = EqualsCheck.reflexivityNonNullSymmetricConsistencyAndTransitivity(first, third, fourth);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return EqualsHashCodeAndToStringCheck.hashcodeCheck(first, second, fourth);
    }

    public static <T> Optional<ContractViolation> hashcodeCheck(T first, T second, T fourth) {
        Optional<ContractViolation> evaluated = HashcodeCheck.equality(first, fourth);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.unequality(first, second);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.consistency(first);
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsAndHashcodeEquality(T object, T otherObject) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.equality(object, otherObject);
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsAndHashcodeUnequality(T object, T otherObject) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.unequality(object, otherObject);
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsHashcodeAndToString(Class<T> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException, ClassNotFoundException, NoSuchFieldException {
        Function<Class, Object> function = arg_0 -> EqualsHashCodeAndToStringCheck.lambda$equalsHashcodeAndToString$0(new EnhancedRandomBuilder().build(), arg_0);
        return EqualsHashCodeAndToStringCheck.equalsHashcodeAndToString(cls, function);
    }

    public static <T> Optional<ContractViolation> equalsHashcodeAndToString(Class<T> cls, Function<Class<T>, T> function) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException, ClassNotFoundException, NoSuchFieldException {
        if (cls == null) {
            return Optional.of(ToStringContractViolation.CLASS_NULL_ARGUMENT);
        }
        T first = function.apply(cls);
        Object second = null;
        while ((second = second == null ? (Object)function.apply(cls) : RandomObjectFactory.newRandomObject(cls, (String[])new String[0])).equals(first)) {
        }
        Object third = CloneObjectExtensions.cloneObject(first);
        Object fourth = CloneObjectExtensions.cloneObject((Object)third);
        return EqualsHashCodeAndToStringCheck.equalsHashcodeAndToString(first, second, third, fourth);
    }

    public static <T> Optional<ContractViolation> equalsHashcodeAndToString(T object) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityAndNonNull(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.consistency(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = ToStringCheck.consistency(object);
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsHashcodeAndToString(T first, T second, T third, T fourth) {
        Optional<ContractViolation> evaluated = EqualsHashCodeAndToStringCheck.equalsAndHashcode(first, second, third, fourth);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return ToStringCheck.evaluateAndConsistency(first);
    }

    private EqualsHashCodeAndToStringCheck() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ Object lambda$equalsHashcodeAndToString$0(EnhancedRandom rec$, Class x$0) {
        return rec$.nextObject(x$0, new String[0]);
    }
}

