/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.model;

import de.alpharogroup.jgeohash.GeoHashExtensions;
import de.alpharogroup.jgeohash.model.FirstRingRegion;

public class FirstAndSecondRingRegion
extends FirstRingRegion {
    private static final long serialVersionUID = -6668301917974379694L;
    private final String northNorth;
    private final String northNorthWest;
    private final String northWestNorthWest;
    private final String westNorthWest;
    private final String northNorthEast;
    private final String northEastNorthEast;
    private final String eastNorthEast;
    private final String eastEast;
    private final String eastSouthEast;
    private final String southSouthEast;
    private final String southEastSouthEast;
    private final String southSouth;
    private final String southSouthWest;
    private final String southWestSouthWest;
    private final String westSouthWest;
    private final String westWest;

    public FirstAndSecondRingRegion(String geohash) {
        super(geohash);
        this.northNorth = GeoHashExtensions.getAdjacent(geohash, "top", "top");
        this.northNorthWest = GeoHashExtensions.getAdjacent(geohash, "top", "left", "top");
        this.northWestNorthWest = GeoHashExtensions.getAdjacent(geohash, "top", "left", "top", "left");
        this.westNorthWest = GeoHashExtensions.getAdjacent(geohash, "top", "left", "left");
        this.northNorthEast = GeoHashExtensions.getAdjacent(geohash, "top", "right", "top");
        this.northEastNorthEast = GeoHashExtensions.getAdjacent(geohash, "top", "right", "top", "right");
        this.eastNorthEast = GeoHashExtensions.getAdjacent(geohash, "top", "right", "right");
        this.eastEast = GeoHashExtensions.getAdjacent(geohash, "right", "right");
        this.eastSouthEast = GeoHashExtensions.getAdjacent(geohash, "bottom", "right", "right");
        this.southSouthEast = GeoHashExtensions.getAdjacent(geohash, "bottom", "right", "bottom");
        this.southEastSouthEast = GeoHashExtensions.getAdjacent(geohash, "bottom", "right", "bottom", "right");
        this.southSouth = GeoHashExtensions.getAdjacent(geohash, "bottom", "bottom");
        this.southSouthWest = GeoHashExtensions.getAdjacent(geohash, "bottom", "left", "bottom");
        this.southWestSouthWest = GeoHashExtensions.getAdjacent(geohash, "bottom", "left", "bottom", "left");
        this.westSouthWest = GeoHashExtensions.getAdjacent(geohash, "bottom", "left", "left");
        this.westWest = GeoHashExtensions.getAdjacent(geohash, "left", "left");
    }

    @Override
    public Object clone() {
        return new FirstAndSecondRingRegion(this.getCenter());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirstAndSecondRingRegion other = (FirstAndSecondRingRegion)obj;
        if (this.eastEast == null ? other.eastEast != null : !this.eastEast.equals(other.eastEast)) {
            return false;
        }
        if (this.eastNorthEast == null ? other.eastNorthEast != null : !this.eastNorthEast.equals(other.eastNorthEast)) {
            return false;
        }
        if (this.eastSouthEast == null ? other.eastSouthEast != null : !this.eastSouthEast.equals(other.eastSouthEast)) {
            return false;
        }
        if (this.northEastNorthEast == null ? other.northEastNorthEast != null : !this.northEastNorthEast.equals(other.northEastNorthEast)) {
            return false;
        }
        if (this.northNorth == null ? other.northNorth != null : !this.northNorth.equals(other.northNorth)) {
            return false;
        }
        if (this.northNorthEast == null ? other.northNorthEast != null : !this.northNorthEast.equals(other.northNorthEast)) {
            return false;
        }
        if (this.northNorthWest == null ? other.northNorthWest != null : !this.northNorthWest.equals(other.northNorthWest)) {
            return false;
        }
        if (this.northWestNorthWest == null ? other.northWestNorthWest != null : !this.northWestNorthWest.equals(other.northWestNorthWest)) {
            return false;
        }
        if (this.southEastSouthEast == null ? other.southEastSouthEast != null : !this.southEastSouthEast.equals(other.southEastSouthEast)) {
            return false;
        }
        if (this.southSouth == null ? other.southSouth != null : !this.southSouth.equals(other.southSouth)) {
            return false;
        }
        if (this.southSouthEast == null ? other.southSouthEast != null : !this.southSouthEast.equals(other.southSouthEast)) {
            return false;
        }
        if (this.southSouthWest == null ? other.southSouthWest != null : !this.southSouthWest.equals(other.southSouthWest)) {
            return false;
        }
        if (this.southWestSouthWest == null ? other.southWestSouthWest != null : !this.southWestSouthWest.equals(other.southWestSouthWest)) {
            return false;
        }
        if (this.westNorthWest == null ? other.westNorthWest != null : !this.westNorthWest.equals(other.westNorthWest)) {
            return false;
        }
        if (this.westSouthWest == null ? other.westSouthWest != null : !this.westSouthWest.equals(other.westSouthWest)) {
            return false;
        }
        return !(this.westWest == null ? other.westWest != null : !this.westWest.equals(other.westWest));
    }

    public String getEastEast() {
        return this.eastEast;
    }

    public String getEastNorthEast() {
        return this.eastNorthEast;
    }

    public String getEastSouthEast() {
        return this.eastSouthEast;
    }

    public String getNorthEastNorthEast() {
        return this.northEastNorthEast;
    }

    public String getNorthNorth() {
        return this.northNorth;
    }

    public String getNorthNorthEast() {
        return this.northNorthEast;
    }

    public String getNorthNorthWest() {
        return this.northNorthWest;
    }

    public String getNorthWestNorthWest() {
        return this.northWestNorthWest;
    }

    public String getSouthEastSouthEast() {
        return this.southEastSouthEast;
    }

    public String getSouthSouth() {
        return this.southSouth;
    }

    public String getSouthSouthEast() {
        return this.southSouthEast;
    }

    public String getSouthSouthWest() {
        return this.southSouthWest;
    }

    public String getSouthWestSouthWest() {
        return this.southWestSouthWest;
    }

    public String getWestNorthWest() {
        return this.westNorthWest;
    }

    public String getWestSouthWest() {
        return this.westSouthWest;
    }

    public String getWestWest() {
        return this.westWest;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.eastEast == null ? 0 : this.eastEast.hashCode());
        result = 31 * result + (this.eastNorthEast == null ? 0 : this.eastNorthEast.hashCode());
        result = 31 * result + (this.eastSouthEast == null ? 0 : this.eastSouthEast.hashCode());
        result = 31 * result + (this.northEastNorthEast == null ? 0 : this.northEastNorthEast.hashCode());
        result = 31 * result + (this.northNorth == null ? 0 : this.northNorth.hashCode());
        result = 31 * result + (this.northNorthEast == null ? 0 : this.northNorthEast.hashCode());
        result = 31 * result + (this.northNorthWest == null ? 0 : this.northNorthWest.hashCode());
        result = 31 * result + (this.northWestNorthWest == null ? 0 : this.northWestNorthWest.hashCode());
        result = 31 * result + (this.southEastSouthEast == null ? 0 : this.southEastSouthEast.hashCode());
        result = 31 * result + (this.southSouth == null ? 0 : this.southSouth.hashCode());
        result = 31 * result + (this.southSouthEast == null ? 0 : this.southSouthEast.hashCode());
        result = 31 * result + (this.southSouthWest == null ? 0 : this.southSouthWest.hashCode());
        result = 31 * result + (this.southWestSouthWest == null ? 0 : this.southWestSouthWest.hashCode());
        result = 31 * result + (this.westNorthWest == null ? 0 : this.westNorthWest.hashCode());
        result = 31 * result + (this.westSouthWest == null ? 0 : this.westSouthWest.hashCode());
        result = 31 * result + (this.westWest == null ? 0 : this.westWest.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[SecondRingRegion:");
        buffer.append("center:");
        buffer.append(this.getCenter());
        buffer.append(" east:");
        buffer.append(this.getEast());
        buffer.append(" west:");
        buffer.append(this.getWest());
        buffer.append(" north:");
        buffer.append(this.getNorth());
        buffer.append(" south:");
        buffer.append(this.getSouth());
        buffer.append(" southEast:");
        buffer.append(this.getSouthEast());
        buffer.append(" northEast:");
        buffer.append(this.getNorthEast());
        buffer.append(" northWest:");
        buffer.append(this.getNorthWest());
        buffer.append(" southWest:");
        buffer.append(this.getSouthWest());
        buffer.append(" northNorth:");
        buffer.append(this.northNorth);
        buffer.append(" northNorthWest:");
        buffer.append(this.northNorthWest);
        buffer.append(" northWestNorthWest:");
        buffer.append(this.northWestNorthWest);
        buffer.append(" westNorthWest:");
        buffer.append(this.westNorthWest);
        buffer.append(" northNorthEast:");
        buffer.append(this.northNorthEast);
        buffer.append(" northEastNorthEast:");
        buffer.append(this.northEastNorthEast);
        buffer.append(" eastNorthEast:");
        buffer.append(this.eastNorthEast);
        buffer.append(" eastEast:");
        buffer.append(this.eastEast);
        buffer.append(" eastSouthEast:");
        buffer.append(this.eastSouthEast);
        buffer.append(" southSouthEast:");
        buffer.append(this.southSouthEast);
        buffer.append(" southEastSouthEast:");
        buffer.append(this.southEastSouthEast);
        buffer.append(" southSouth:");
        buffer.append(this.southSouth);
        buffer.append(" southSouthWest:");
        buffer.append(this.southSouthWest);
        buffer.append(" southWestSouthWest:");
        buffer.append(this.southWestSouthWest);
        buffer.append(" westSouthWest:");
        buffer.append(this.westSouthWest);
        buffer.append(" westWest:");
        buffer.append(this.westWest);
        buffer.append("]");
        return buffer.toString();
    }
}

