/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash;

import de.alpharogroup.jgeohash.Adjacent;
import de.alpharogroup.jgeohash.GeoHashPoint;
import de.alpharogroup.jgeohash.model.FirstAndSecondRingRegion;
import de.alpharogroup.jgeohash.model.FirstRingRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GeoHashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final Map<Character, Integer> DECODE_MAP = new HashMap<Character, Integer>();
    private static final int precision = 12;
    private static final int[] bits;

    public static double[] decode(String geohash) {
        if (geohash == null || geohash.isEmpty()) {
            throw new IllegalArgumentException("Argument geohash should not be null.");
        }
        boolean even = true;
        double latitudeError = 90.0;
        double longitudeError = 180.0;
        double[] latitudeInterval = new double[]{-90.0, 90.0};
        double[] longitudeInterval = new double[]{-180.0, 180.0};
        for (int i = 0; i < geohash.length(); ++i) {
            int cd = DECODE_MAP.get(Character.valueOf(geohash.charAt(i)));
            for (int j = 0; j < bits.length; ++j) {
                int mask = bits[j];
                if (even) {
                    longitudeError /= 2.0;
                    if ((cd & mask) != 0) {
                        longitudeInterval[0] = (longitudeInterval[0] + longitudeInterval[1]) / 2.0;
                    } else {
                        longitudeInterval[1] = (longitudeInterval[0] + longitudeInterval[1]) / 2.0;
                    }
                } else {
                    latitudeError /= 2.0;
                    if ((cd & mask) != 0) {
                        latitudeInterval[0] = (latitudeInterval[0] + latitudeInterval[1]) / 2.0;
                    } else {
                        latitudeInterval[1] = (latitudeInterval[0] + latitudeInterval[1]) / 2.0;
                    }
                }
                even = !even;
            }
        }
        double latitude = (latitudeInterval[0] + latitudeInterval[1]) / 2.0;
        double longitude = (longitudeInterval[0] + longitudeInterval[1]) / 2.0;
        return new double[]{latitude, longitude, latitudeError, longitudeError};
    }

    public static double[] decodeAndRound(String geohash) {
        double[] ge = GeoHashUtils.decode(geohash);
        double latitude = ge[0];
        double longitude = ge[1];
        double latitudeError = ge[2];
        double longitudeError = ge[3];
        double latitudePrecision = Math.max(1L, Math.round(-Math.log10(latitudeError))) - 1L;
        double longitudePrecision = Math.max(1L, Math.round(-Math.log10(longitudeError))) - 1L;
        latitude = GeoHashUtils.getPrecision(latitude, latitudePrecision);
        longitude = GeoHashUtils.getPrecision(longitude, longitudePrecision);
        return new double[]{latitude, longitude};
    }

    public static String encode(double latitude, double longitude) {
        StringBuilder geohash = new StringBuilder();
        boolean even = true;
        int bit = 0;
        int ch = 0;
        double[] latitudeInterval = new double[]{-90.0, 90.0};
        double[] longitudeInterval = new double[]{-180.0, 180.0};
        while (geohash.length() < 12) {
            double mid = 0.0;
            if (even) {
                mid = (longitudeInterval[0] + longitudeInterval[1]) / 2.0;
                if (longitude > mid) {
                    ch |= bits[bit];
                    longitudeInterval[0] = mid;
                } else {
                    longitudeInterval[1] = mid;
                }
            } else {
                mid = (latitudeInterval[0] + latitudeInterval[1]) / 2.0;
                if (latitude > mid) {
                    ch |= bits[bit];
                    latitudeInterval[0] = mid;
                } else {
                    latitudeInterval[1] = mid;
                }
            }
            boolean bl = even = !even;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash.append(BASE_32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    public static String getAdjacent(String geohash, String direction) {
        if (geohash == null || geohash.isEmpty()) {
            throw new IllegalArgumentException("Argument geohash should not be null or empty.");
        }
        if (direction == null || direction.isEmpty()) {
            throw new IllegalArgumentException("Argument direction should not be null or empty.");
        }
        String lowerCaseGeohash = geohash.toLowerCase();
        char lastChar = lowerCaseGeohash.charAt(lowerCaseGeohash.length() - 1);
        int modulo = lowerCaseGeohash.length() % 2;
        String type = modulo == 0 ? "odd" : "even";
        String base = lowerCaseGeohash.substring(0, lowerCaseGeohash.length() - 1);
        Map<String, String> borderDirection = Adjacent.Borders.borders.get(direction);
        String borderDirectionType = borderDirection.get(type);
        int indexOfLastChar = borderDirectionType.indexOf(lastChar);
        if (indexOfLastChar != -1 && !base.isEmpty()) {
            base = GeoHashUtils.getAdjacent(base, direction);
        }
        Map<String, String> neighborsDirection = Adjacent.Neighbors.neighbors.get(direction);
        String neighborsDirectionType = neighborsDirection.get(type);
        int i = neighborsDirectionType.indexOf(lastChar);
        char r = BASE_32[i];
        return base + r;
    }

    public static String getAdjacent(String geohash, String ... directions) {
        String geohashresult = geohash;
        for (String direction : directions) {
            geohashresult = GeoHashUtils.getAdjacent(geohashresult, direction);
        }
        return geohashresult;
    }

    public static List<String> getAllAdjacentAreasList(String geohash) {
        if (geohash == null || geohash.isEmpty()) {
            throw new IllegalArgumentException("Argument geohash should not be null.");
        }
        ArrayList<String> adjacentAreas = new ArrayList<String>();
        String top = GeoHashUtils.getAdjacent(geohash, "top");
        String bottom = GeoHashUtils.getAdjacent(geohash, "bottom");
        String right = GeoHashUtils.getAdjacent(geohash, "right");
        String left = GeoHashUtils.getAdjacent(geohash, "left");
        String topleft = GeoHashUtils.getAdjacent(left, "top");
        String topright = GeoHashUtils.getAdjacent(right, "top");
        String bottomright = GeoHashUtils.getAdjacent(right, "bottom");
        String bottomleft = GeoHashUtils.getAdjacent(left, "bottom");
        adjacentAreas.add(geohash);
        adjacentAreas.add(top);
        adjacentAreas.add(topright);
        adjacentAreas.add(right);
        adjacentAreas.add(bottomright);
        adjacentAreas.add(bottom);
        adjacentAreas.add(bottomleft);
        adjacentAreas.add(left);
        adjacentAreas.add(topleft);
        return adjacentAreas;
    }

    public static Map<String, String> getAllAdjacentAreasMap(String geohash) {
        if (geohash == null || geohash.isEmpty()) {
            throw new IllegalArgumentException("Argument geohash should not be null.");
        }
        String top = GeoHashUtils.getAdjacent(geohash, "top");
        String bottom = GeoHashUtils.getAdjacent(geohash, "bottom");
        String right = GeoHashUtils.getAdjacent(geohash, "right");
        String left = GeoHashUtils.getAdjacent(geohash, "left");
        String topleft = GeoHashUtils.getAdjacent(left, "top");
        String topright = GeoHashUtils.getAdjacent(right, "top");
        String bottomright = GeoHashUtils.getAdjacent(right, "bottom");
        String bottomleft = GeoHashUtils.getAdjacent(left, "bottom");
        LinkedHashMap<String, String> adjacentAreas = new LinkedHashMap<String, String>();
        adjacentAreas.put("center", geohash);
        adjacentAreas.put("top", top);
        adjacentAreas.put("bottom", bottom);
        adjacentAreas.put("right", right);
        adjacentAreas.put("left", left);
        adjacentAreas.put("topleft", topleft);
        adjacentAreas.put("topright", topright);
        adjacentAreas.put("bottomright", bottomright);
        adjacentAreas.put("bottomleft", bottomleft);
        return adjacentAreas;
    }

    public static FirstAndSecondRingRegion getFirstAndSecondRingRegion(String geohash) {
        return new FirstAndSecondRingRegion(geohash);
    }

    public static FirstRingRegion getFirstRingRegion(String geohash) {
        return new FirstRingRegion(geohash);
    }

    public static double getLatitude(String geohash) {
        return GeoHashUtils.decodeAndRound(geohash)[0];
    }

    public static double getLongitude(String geohash) {
        return GeoHashUtils.decodeAndRound(geohash)[1];
    }

    private static double getPrecision(double x, double precision) {
        double base = Math.pow(10.0, -precision);
        double diff = x % base;
        return x - diff;
    }

    public static Map<String, String> getTwentyFiveAreasMap(String geohash) {
        Map<String, String> adjacentAreas = GeoHashUtils.getAllAdjacentAreasMap(geohash);
        String topTop = GeoHashUtils.getAdjacent(adjacentAreas.get("top"), "top");
        String topLeftTop = GeoHashUtils.getAdjacent(adjacentAreas.get("topleft"), "top");
        String topLeftTopLeft = GeoHashUtils.getAdjacent(topLeftTop, "left");
        String topLeftLeft = GeoHashUtils.getAdjacent(adjacentAreas.get("topleft"), "left");
        String topRightTop = GeoHashUtils.getAdjacent(adjacentAreas.get("topright"), "top");
        String topRightTopRight = GeoHashUtils.getAdjacent(topRightTop, "right");
        String topRightRight = GeoHashUtils.getAdjacent(adjacentAreas.get("topright"), "right");
        String rightRight = GeoHashUtils.getAdjacent(adjacentAreas.get("right"), "right");
        String bottomRightRight = GeoHashUtils.getAdjacent(adjacentAreas.get("bottomright"), "right");
        String bottomRightBottom = GeoHashUtils.getAdjacent(adjacentAreas.get("bottomright"), "bottom");
        String bottomRightBottomRight = GeoHashUtils.getAdjacent(bottomRightBottom, "right");
        String bottomBottom = GeoHashUtils.getAdjacent(adjacentAreas.get("bottom"), "bottom");
        String bottomLeftBottom = GeoHashUtils.getAdjacent(adjacentAreas.get("bottomleft"), "bottom");
        String bottomLeftBottomLeft = GeoHashUtils.getAdjacent(bottomLeftBottom, "left");
        String bottomLeftLeft = GeoHashUtils.getAdjacent(adjacentAreas.get("bottomleft"), "left");
        String leftLeft = GeoHashUtils.getAdjacent(adjacentAreas.get("left"), "left");
        adjacentAreas.put("topleft_top", topLeftTop);
        adjacentAreas.put("topleft_top_left", topLeftTopLeft);
        adjacentAreas.put("topleft_left", topLeftLeft);
        adjacentAreas.put("top_top", topTop);
        adjacentAreas.put("topright_top", topRightTop);
        adjacentAreas.put("topright_right", topRightRight);
        adjacentAreas.put("topright_top_right", topRightTopRight);
        adjacentAreas.put("right_right", rightRight);
        adjacentAreas.put("bottomright_right", bottomRightRight);
        adjacentAreas.put("bottomright_bottom", bottomRightBottom);
        adjacentAreas.put("bottomright_bottom_right", bottomRightBottomRight);
        adjacentAreas.put("bottom_bottom", bottomBottom);
        adjacentAreas.put("bottomleft_bottom", bottomLeftBottom);
        adjacentAreas.put("bottomleft_bottom_left", bottomLeftBottomLeft);
        adjacentAreas.put("bottomleft_left", bottomLeftLeft);
        adjacentAreas.put("left_left", leftLeft);
        return adjacentAreas;
    }

    public static void main(String[] args) {
        String alterTeichwegGeohash = "u1x0v54rmjwej";
        String gc1 = GeoHashUtils.encode(30.0, -90.0);
        String gc2 = GeoHashUtils.encode(51.4797, -0.0124);
        String geohash = GeoHashUtils.encode(53.5526394, 10.0067103);
        System.out.println("geohash:" + geohash);
        System.out.println("gc1:" + gc1);
        System.out.println("gc2:" + gc2);
        double[] gd1 = GeoHashUtils.decodeAndRound(gc1);
        double[] gd2 = GeoHashUtils.decodeAndRound(gc2);
        System.out.println(gd1[0] + ", " + gd1[1]);
        System.out.println(gd2[0] + ", " + gd2[1]);
        gd1 = GeoHashUtils.decode(gc1);
        gd2 = GeoHashUtils.decode(gc2);
        double[] decoded = GeoHashUtils.decode(geohash);
        System.out.println(gd1[0] + ", " + gd1[1]);
        System.out.println(gd2[0] + ", " + gd2[1]);
        System.out.println(decoded[0] + ", " + decoded[1]);
        String geohashTest = "u1x0v54rmjwej";
        String top = GeoHashUtils.getAdjacent("u1x0v54rmjwej", "top");
        System.out.println("top:\t\t" + top);
        String bottom = GeoHashUtils.getAdjacent("u1x0v54rmjwej", "bottom");
        System.out.println("bottom:\t\t" + bottom);
        String right = GeoHashUtils.getAdjacent("u1x0v54rmjwej", "right");
        System.out.println("right:\t\t" + right);
        String left = GeoHashUtils.getAdjacent("u1x0v54rmjwej", "left");
        System.out.println("left:\t\t" + left);
        String topleft = GeoHashUtils.getAdjacent(left, "top");
        System.out.println("topleft:\t" + topleft);
        String topright = GeoHashUtils.getAdjacent(right, "top");
        System.out.println("topright:\t" + topright);
        String bottomright = GeoHashUtils.getAdjacent(right, "bottom");
        System.out.println("bottomright:\t" + bottomright);
        String bottomleft = GeoHashUtils.getAdjacent(left, "bottom");
        System.out.println("bottomleft:\t" + bottomleft);
        String subGeohash = geohash.substring(0, 7);
        Map<String, String> adjacentAreas = GeoHashUtils.getAllAdjacentAreasMap(subGeohash);
        System.out.println(adjacentAreas);
        System.out.println("=======================================");
        List<String> aa = GeoHashUtils.getAllAdjacentAreasList(subGeohash);
        System.out.println(aa);
        System.out.println("=======================================");
        GeoHashPoint geohashPoint1 = new GeoHashPoint(geohash);
        GeoHashPoint geohashPoint2 = new GeoHashPoint(geohash);
        System.out.println(geohashPoint1);
        System.out.println(geohashPoint2);
        int c = geohashPoint1.compareTo(geohashPoint2);
        System.out.println(c);
    }

    static {
        int counter = 0;
        for (char c : BASE_32) {
            DECODE_MAP.put(Character.valueOf(c), counter++);
        }
        bits = new int[]{16, 8, 4, 2, 1};
    }
}

