/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.model;

import de.alpharogroup.jgeohash.GeoHashUtils;
import java.io.Serializable;

public class FirstRingRegion
implements Serializable {
    private static final long serialVersionUID = -1690885107068325816L;
    private final String center;
    private final String east;
    private final String west;
    private final String north;
    private final String south;
    private final String southEast;
    private final String northEast;
    private final String northWest;
    private final String southWest;

    public FirstRingRegion(String geohash) {
        this.center = geohash;
        this.east = GeoHashUtils.getAdjacent(geohash, "right");
        this.west = GeoHashUtils.getAdjacent(geohash, "left");
        this.north = GeoHashUtils.getAdjacent(geohash, "top");
        this.south = GeoHashUtils.getAdjacent(geohash, "bottom");
        this.southEast = GeoHashUtils.getAdjacent(this.south, "right");
        this.northEast = GeoHashUtils.getAdjacent(this.north, "right");
        this.northWest = GeoHashUtils.getAdjacent(this.north, "left");
        this.southWest = GeoHashUtils.getAdjacent(this.south, "left");
    }

    public Object clone() {
        return new FirstRingRegion(this.center);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        FirstRingRegion castedObj = (FirstRingRegion)o;
        return (this.center == null ? castedObj.center == null : this.center.equals(castedObj.center)) && (this.east == null ? castedObj.east == null : this.east.equals(castedObj.east)) && (this.west == null ? castedObj.west == null : this.west.equals(castedObj.west)) && (this.north == null ? castedObj.north == null : this.north.equals(castedObj.north)) && (this.south == null ? castedObj.south == null : this.south.equals(castedObj.south)) && (this.southEast == null ? castedObj.southEast == null : this.southEast.equals(castedObj.southEast)) && (this.northEast == null ? castedObj.northEast == null : this.northEast.equals(castedObj.northEast)) && (this.northWest == null ? castedObj.northWest == null : this.northWest.equals(castedObj.northWest)) && (this.southWest == null ? castedObj.southWest == null : this.southWest.equals(castedObj.southWest));
    }

    public String getCenter() {
        return this.center;
    }

    public String getEast() {
        return this.east;
    }

    public String getNorth() {
        return this.north;
    }

    public String getNorthEast() {
        return this.northEast;
    }

    public String getNorthWest() {
        return this.northWest;
    }

    public String getSouth() {
        return this.south;
    }

    public String getSouthEast() {
        return this.southEast;
    }

    public String getSouthWest() {
        return this.southWest;
    }

    public String getWest() {
        return this.west;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + -977701700;
        hashCode = 31 * hashCode + (this.center == null ? 0 : this.center.hashCode());
        hashCode = 31 * hashCode + (this.east == null ? 0 : this.east.hashCode());
        hashCode = 31 * hashCode + (this.west == null ? 0 : this.west.hashCode());
        hashCode = 31 * hashCode + (this.north == null ? 0 : this.north.hashCode());
        hashCode = 31 * hashCode + (this.south == null ? 0 : this.south.hashCode());
        hashCode = 31 * hashCode + (this.southEast == null ? 0 : this.southEast.hashCode());
        hashCode = 31 * hashCode + (this.northEast == null ? 0 : this.northEast.hashCode());
        hashCode = 31 * hashCode + (this.northWest == null ? 0 : this.northWest.hashCode());
        hashCode = 31 * hashCode + (this.southWest == null ? 0 : this.southWest.hashCode());
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[GeoHashRegion:");
        buffer.append(" center:");
        buffer.append(this.center);
        buffer.append(" east:");
        buffer.append(this.east);
        buffer.append(" west:");
        buffer.append(this.west);
        buffer.append(" north:");
        buffer.append(this.north);
        buffer.append(" south:");
        buffer.append(this.south);
        buffer.append(" southEast:");
        buffer.append(this.southEast);
        buffer.append(" northEast:");
        buffer.append(this.northEast);
        buffer.append(" northWest:");
        buffer.append(this.northWest);
        buffer.append(" southWest:");
        buffer.append(this.southWest);
        buffer.append("]");
        return buffer.toString();
    }
}

