/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash;

import de.alpharogroup.jgeohash.api.Position;

public class Point
implements Comparable<Point>,
Cloneable,
Position {
    private static final long serialVersionUID = -4799959551221362673L;
    private double latitude;
    private double longitude;

    public Point(double latitude, double longitude) {
        if (Math.abs(latitude) > 90.0 || Math.abs(longitude) > 180.0) {
            throw new IllegalArgumentException("The given coordinates " + this.toString() + " are out of range.");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Object clone() {
        Point inst = new Point(this.latitude, this.longitude);
        return inst;
    }

    @Override
    public int compareTo(Point other) {
        if (this == other) {
            return 0;
        }
        if (this.latitude < other.latitude) {
            return -1;
        }
        if (this.latitude > other.latitude) {
            return 1;
        }
        if (this.longitude < other.longitude) {
            return -1;
        }
        if (this.longitude > other.longitude) {
            return 1;
        }
        assert (this.equals(other)) : "compareTo inconsistent with equals.";
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Point castedObj = (Point)o;
        return this.latitude == castedObj.latitude && this.longitude == castedObj.longitude;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + -1873408457;
        hashCode = 31 * hashCode + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        hashCode = 31 * hashCode + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        return hashCode;
    }

    @Override
    public void setLatitude(double latitude) {
        if (Math.abs(latitude) > 90.0) {
            throw new IllegalArgumentException("The given coordinates for latitude " + latitude + " are out of range.");
        }
        this.latitude = latitude;
    }

    @Override
    public void setLongitude(double longitude) {
        if (Math.abs(longitude) > 180.0) {
            throw new IllegalArgumentException("The given coordinates for longitude " + longitude + " are out of range.");
        }
        this.longitude = longitude;
    }

    public String toString() {
        return "Latitude : " + this.latitude + "   Longitude  : " + this.longitude;
    }
}

