/*
 * Decompiled with CFR 0.152.
 */
package org.jgeohash;

import java.math.BigDecimal;
import org.jgeohash.GeoHashUtils;
import org.jgeohash.Point;
import org.jgeohash.api.Position;

public class GeoHashPoint
extends Point {
    private static final long serialVersionUID = -3580536765079661097L;
    public static final String GEOHASH_KEY = "GEOHASH_KEY";

    public GeoHashPoint(double latitude, double longitude) {
        super(latitude, longitude);
    }

    public GeoHashPoint(Double latitude, Double longitude) {
        super(latitude, longitude);
    }

    public GeoHashPoint(Position position) {
        this(position.getLatitude(), position.getLongitude());
    }

    public GeoHashPoint(float latitude, float longitude) {
        this(Float.toString(latitude), Float.toString(longitude));
    }

    public GeoHashPoint(String lat, String lng) {
        super(Double.parseDouble(lat), Double.parseDouble(lng));
    }

    public GeoHashPoint(String geohash) {
        super(GeoHashUtils.decode(geohash)[0], GeoHashUtils.decode(geohash)[1]);
    }

    public String getGeohash() {
        return GeoHashUtils.encode(this.getLatitude(), this.getLongitude());
    }

    public BigDecimal getLat() {
        return BigDecimal.valueOf(this.getLatitude());
    }

    public BigDecimal getLng() {
        return BigDecimal.valueOf(this.getLongitude());
    }

    @Override
    public Object clone() {
        return new GeoHashPoint(this.getLatitude(), this.getLongitude());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        GeoHashPoint castedObj = (GeoHashPoint)o;
        return this.getLatitude() == castedObj.getLatitude() && this.getLongitude() == castedObj.getLongitude();
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 31 * hashCode + -1837353697;
        hashCode = 31 * hashCode + (GEOHASH_KEY == null ? 0 : GEOHASH_KEY.hashCode());
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[GeoHashPoint:");
        buffer.append(super.toString());
        buffer.append("   Geohash : ");
        buffer.append(this.getGeohash());
        buffer.append("]");
        return buffer.toString();
    }
}

