/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.geoip;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import de.alpharogroup.jgeohash.GeoHashPoint;
import de.alpharogroup.jgeohash.api.Position;
import de.alpharogroup.jgeohash.distance.DistanceCalculator;
import de.alpharogroup.jgeohash.distance.DistancePoint;
import de.alpharogroup.jgeohash.distance.MeasuringUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LocationExtensions {
    public static List<DistancePoint> getDistancePoints(Position startPoint, List<Position> geohashes, MeasuringUnit unit) {
        ArrayList<DistancePoint> distancePoints = new ArrayList<DistancePoint>();
        for (Position geoHashPoint : geohashes) {
            DistancePoint distancePoint = new DistancePoint(geoHashPoint, Double.valueOf(DistanceCalculator.distanceBetweenPoints((Position)startPoint, (Position)geoHashPoint, (MeasuringUnit)unit)));
            distancePoints.add(distancePoint);
        }
        return distancePoints;
    }

    public static String getGeohashFromIpAddress(LookupService lookupService, String ipAddress) {
        GeoHashPoint geoHashPoint = LocationExtensions.getGeoHashPoint(lookupService, ipAddress);
        if (geoHashPoint != null) {
            return geoHashPoint.getGeohash();
        }
        return "";
    }

    public static GeoHashPoint getGeoHashPoint(LookupService lookupService, String ipAddress) {
        Location lc = lookupService.getLocation(ipAddress);
        if (lc != null) {
            return new GeoHashPoint(lc.latitude, lc.longitude);
        }
        return null;
    }

    public static List<Position> sortByDistance(Position startPoint, List<Position> geohashes, MeasuringUnit unit) {
        List<DistancePoint> distancePoints = LocationExtensions.getDistancePoints(startPoint, geohashes, unit);
        Collections.sort(distancePoints);
        ArrayList<Position> geosorted = new ArrayList<Position>();
        for (int i = 0; i < distancePoints.size(); ++i) {
            geosorted.add(distancePoints.get(i).getPoint());
        }
        return geosorted;
    }

    public static List<Position> sortByDistanceInMeters(Position startPoint, List<Position> geohashes) {
        return LocationExtensions.sortByDistance(startPoint, geohashes, MeasuringUnit.METER);
    }

    private LocationExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

