/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.geoip;

import com.maxmind.geoip.LookupService;
import de.alpharogroup.lang.ClassExtensions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class LookupServiceSingleton {
    private static final Logger LOGGER = Logger.getLogger((String)LookupServiceSingleton.class.getName());
    private static volatile LookupService instance;
    private static final String PREFIX = "GeoLiteCity";
    private static final String SUFFIX = ".dat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LookupService getInstance() {
        if (instance != null) return instance;
        Class<LookupServiceSingleton> clazz = LookupServiceSingleton.class;
        synchronized (LookupServiceSingleton.class) {
            if (instance != null) return instance;
            File fileLocation = null;
            InputStream is = ClassExtensions.getResourceAsStream((String)"GeoLiteCity.dat");
            try {
                fileLocation = LookupServiceSingleton.inputStreamToFile(is);
                instance = new LookupService(fileLocation, 1);
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException in the initialization of the LookupService.", (Throwable)e);
            }
            return instance;
        }
    }

    private static File inputStreamToFile(InputStream inputStream) throws IOException {
        File tempFile = File.createTempFile(PREFIX, SUFFIX);
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        return tempFile;
    }

    private LookupServiceSingleton() {
    }
}

