/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.model;

import de.alpharogroup.jgeohash.model.Section;
import de.alpharogroup.jgeohash.model.SectionComparator;
import de.alpharogroup.merge.api.Summarizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Sectionizer
implements Summarizer<Section> {
    public static final int DEFAULT_MAX_ITERATION = 9999;
    private int maxIteration;

    private static List<Section> clean(List<Section> mergeSections, List<Section> toRemove) {
        HashSet<Section> set = new HashSet<Section>(mergeSections);
        set.removeAll(toRemove);
        ArrayList<Section> mergedSections = new ArrayList<Section>(set);
        Collections.sort(mergedSections, new SectionComparator());
        return mergedSections;
    }

    public List<Section> merge(List<Section> sections) {
        ArrayList<Section> toAdd = new ArrayList<Section>();
        ArrayList<Section> toRemove = new ArrayList<Section>();
        Collections.sort(sections, new SectionComparator());
        List<Section> mergedSections = new ArrayList<Section>(sections);
        ArrayList<Section> lastIterated = new ArrayList<Section>(mergedSections);
        int initialSize = mergedSections.size();
        boolean mergable = true;
        for (int count = 0; mergable && count < this.maxIteration; ++count) {
            this.merge(mergedSections, toAdd, toRemove);
            mergedSections = Sectionizer.clean(toAdd, toRemove);
            toAdd.clear();
            toRemove.clear();
            int newSize = mergedSections.size();
            if (initialSize == newSize && mergedSections.equals(lastIterated)) {
                mergable = false;
                break;
            }
            initialSize = newSize;
            lastIterated = new ArrayList<Section>(mergedSections);
        }
        return mergedSections;
    }

    private void merge(List<Section> sourceSections, List<Section> mergedSections, List<Section> toRemove) {
        for (Section clonedSection : sourceSections) {
            for (Section section : sourceSections) {
                if (clonedSection.equals(section)) {
                    if (mergedSections.contains(section)) continue;
                    mergedSections.add(section);
                    continue;
                }
                Section mergeSection = this.merge(clonedSection, section);
                if (!clonedSection.equals(mergeSection)) {
                    if (!mergedSections.contains(mergeSection)) {
                        mergedSections.add(mergeSection);
                    }
                    if (!toRemove.contains(clonedSection) && !mergeSection.equals(clonedSection)) {
                        toRemove.add(clonedSection);
                    }
                    if (toRemove.contains(section) || mergeSection.equals(section)) continue;
                    toRemove.add(section);
                    continue;
                }
                if (mergedSections.contains(section)) continue;
                mergedSections.add(section);
            }
        }
    }

    public Section merge(Section object, Section other) {
        return object.merge(other);
    }

    private static int $default$maxIteration() {
        return 9999;
    }

    Sectionizer(int maxIteration) {
        this.maxIteration = maxIteration;
    }

    public static SectionizerBuilder builder() {
        return new SectionizerBuilder();
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int maxIteration) {
        this.maxIteration = maxIteration;
    }

    public static class SectionizerBuilder {
        private boolean maxIteration$set;
        private int maxIteration;

        SectionizerBuilder() {
        }

        public SectionizerBuilder maxIteration(int maxIteration) {
            this.maxIteration = maxIteration;
            this.maxIteration$set = true;
            return this;
        }

        public Sectionizer build() {
            int maxIteration = this.maxIteration;
            if (!this.maxIteration$set) {
                maxIteration = Sectionizer.$default$maxIteration();
            }
            return new Sectionizer(maxIteration);
        }

        public String toString() {
            return "Sectionizer.SectionizerBuilder(maxIteration=" + this.maxIteration + ")";
        }
    }
}

