/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.model;

import de.alpharogroup.merge.api.Mergeable;

public class Section
implements Mergeable<Section> {
    private final int end;
    private final int start;

    public static boolean isBetween(int min, int max, int index, boolean includeMin, boolean includeMax) {
        if (includeMin && includeMax) {
            return index >= min && index <= max;
        }
        if (includeMin && !includeMax) {
            return index >= min && index < max;
        }
        if (!includeMin && includeMax) {
            return index > min && index <= max;
        }
        return min < index && index < max;
    }

    public boolean isBetween(Section other) {
        boolean start = Section.isBetween(this.start, this.end, other.start, true, true);
        boolean end = Section.isBetween(this.start, this.end, other.end, true, true);
        boolean between = start && end;
        return between;
    }

    public boolean isToLeft(Section other) {
        int oneAfter = other.getEnd() + 1;
        return this.start == oneAfter;
    }

    public boolean isToRight(Section other) {
        int oneBefore = other.getStart() - 1;
        return this.end == oneBefore;
    }

    public Section merge(Section other) {
        Section merged = this;
        if (this.isToLeft(other)) {
            merged = Section.builder().start(other.getStart()).end(this.end).build();
            return merged;
        }
        if (this.isToRight(other)) {
            merged = Section.builder().start(this.getStart()).end(other.end).build();
            return merged;
        }
        boolean overlapsWith = this.overlapsWith(other);
        if (overlapsWith) {
            if (this.getStart() <= other.getStart()) {
                if (this.getEnd() >= other.getEnd()) {
                    merged = this;
                    return merged;
                }
                merged = Section.builder().start(this.getStart()).end(other.getEnd()).build();
                return merged;
            }
            if (this.getEnd() >= other.getEnd()) {
                merged = Section.builder().start(other.getStart()).end(this.getEnd()).build();
                return merged;
            }
            merged = Section.builder().start(other.getStart()).end(other.getEnd()).build();
            return merged;
        }
        return merged;
    }

    public boolean overlapsWith(Section other) {
        return this.start <= other.start && this.end >= other.start || this.start <= other.end && this.end >= other.end || this.start >= other.start && this.start <= other.end || this.end >= other.start && this.end <= other.end;
    }

    public static SectionBuilder builder() {
        return new SectionBuilder();
    }

    public SectionBuilder toBuilder() {
        return new SectionBuilder().end(this.end).start(this.start);
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Section)) {
            return false;
        }
        Section other = (Section)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        return this.getStart() == other.getStart();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Section;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEnd();
        result = result * 59 + this.getStart();
        return result;
    }

    public String toString() {
        return "Section(end=" + this.getEnd() + ", start=" + this.getStart() + ")";
    }

    public Section(int end, int start) {
        this.end = end;
        this.start = start;
    }

    public static class SectionBuilder {
        private int end;
        private int start;

        SectionBuilder() {
        }

        public SectionBuilder end(int end) {
            this.end = end;
            return this;
        }

        public SectionBuilder start(int start) {
            this.start = start;
            return this;
        }

        public Section build() {
            return new Section(this.end, this.start);
        }

        public String toString() {
            return "Section.SectionBuilder(end=" + this.end + ", start=" + this.start + ")";
        }
    }
}

