/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.model;

import de.alpharogroup.jgeohash.GeoHashExtensions;
import java.io.Serializable;

public class FirstRingRegion
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1L;
    private final String center;
    private final String east;
    private final String north;
    private final String northEast;
    private final String northWest;
    private final String south;
    private final String southEast;
    private final String southWest;
    private final String west;

    public FirstRingRegion(String geohash) {
        this.center = geohash;
        this.east = GeoHashExtensions.getAdjacent(geohash, "right");
        this.west = GeoHashExtensions.getAdjacent(geohash, "left");
        this.north = GeoHashExtensions.getAdjacent(geohash, "top");
        this.south = GeoHashExtensions.getAdjacent(geohash, "bottom");
        this.southEast = GeoHashExtensions.getAdjacent(this.south, "right");
        this.northEast = GeoHashExtensions.getAdjacent(this.north, "right");
        this.northWest = GeoHashExtensions.getAdjacent(this.north, "left");
        this.southWest = GeoHashExtensions.getAdjacent(this.south, "left");
    }

    public Object clone() {
        return new FirstRingRegion(this.center);
    }

    public String getCenter() {
        return this.center;
    }

    public String getEast() {
        return this.east;
    }

    public String getNorth() {
        return this.north;
    }

    public String getNorthEast() {
        return this.northEast;
    }

    public String getNorthWest() {
        return this.northWest;
    }

    public String getSouth() {
        return this.south;
    }

    public String getSouthEast() {
        return this.southEast;
    }

    public String getSouthWest() {
        return this.southWest;
    }

    public String getWest() {
        return this.west;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FirstRingRegion)) {
            return false;
        }
        FirstRingRegion other = (FirstRingRegion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$center = this.getCenter();
        String other$center = other.getCenter();
        if (this$center == null ? other$center != null : !this$center.equals(other$center)) {
            return false;
        }
        String this$east = this.getEast();
        String other$east = other.getEast();
        if (this$east == null ? other$east != null : !this$east.equals(other$east)) {
            return false;
        }
        String this$north = this.getNorth();
        String other$north = other.getNorth();
        if (this$north == null ? other$north != null : !this$north.equals(other$north)) {
            return false;
        }
        String this$northEast = this.getNorthEast();
        String other$northEast = other.getNorthEast();
        if (this$northEast == null ? other$northEast != null : !this$northEast.equals(other$northEast)) {
            return false;
        }
        String this$northWest = this.getNorthWest();
        String other$northWest = other.getNorthWest();
        if (this$northWest == null ? other$northWest != null : !this$northWest.equals(other$northWest)) {
            return false;
        }
        String this$south = this.getSouth();
        String other$south = other.getSouth();
        if (this$south == null ? other$south != null : !this$south.equals(other$south)) {
            return false;
        }
        String this$southEast = this.getSouthEast();
        String other$southEast = other.getSouthEast();
        if (this$southEast == null ? other$southEast != null : !this$southEast.equals(other$southEast)) {
            return false;
        }
        String this$southWest = this.getSouthWest();
        String other$southWest = other.getSouthWest();
        if (this$southWest == null ? other$southWest != null : !this$southWest.equals(other$southWest)) {
            return false;
        }
        String this$west = this.getWest();
        String other$west = other.getWest();
        return !(this$west == null ? other$west != null : !this$west.equals(other$west));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FirstRingRegion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $center = this.getCenter();
        result = result * 59 + ($center == null ? 43 : $center.hashCode());
        String $east = this.getEast();
        result = result * 59 + ($east == null ? 43 : $east.hashCode());
        String $north = this.getNorth();
        result = result * 59 + ($north == null ? 43 : $north.hashCode());
        String $northEast = this.getNorthEast();
        result = result * 59 + ($northEast == null ? 43 : $northEast.hashCode());
        String $northWest = this.getNorthWest();
        result = result * 59 + ($northWest == null ? 43 : $northWest.hashCode());
        String $south = this.getSouth();
        result = result * 59 + ($south == null ? 43 : $south.hashCode());
        String $southEast = this.getSouthEast();
        result = result * 59 + ($southEast == null ? 43 : $southEast.hashCode());
        String $southWest = this.getSouthWest();
        result = result * 59 + ($southWest == null ? 43 : $southWest.hashCode());
        String $west = this.getWest();
        result = result * 59 + ($west == null ? 43 : $west.hashCode());
        return result;
    }

    public String toString() {
        return "FirstRingRegion(center=" + this.getCenter() + ", east=" + this.getEast() + ", north=" + this.getNorth() + ", northEast=" + this.getNorthEast() + ", northWest=" + this.getNorthWest() + ", south=" + this.getSouth() + ", southEast=" + this.getSouthEast() + ", southWest=" + this.getSouthWest() + ", west=" + this.getWest() + ")";
    }
}

