/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.distance;

import de.alpharogroup.jgeohash.api.Position;

public class DistancePoint
implements Comparable<DistancePoint> {
    private final Double distance;
    private final Position point;

    public DistancePoint(Double distance, Position point) {
        this.distance = distance;
        this.point = point;
    }

    public DistancePoint(Position point, Double distance) {
        this.point = point;
        this.distance = distance;
    }

    @Override
    public int compareTo(DistancePoint o) {
        return this.distance.compareTo(o.distance);
    }

    public static DistancePointBuilder builder() {
        return new DistancePointBuilder();
    }

    public DistancePointBuilder toBuilder() {
        return new DistancePointBuilder().distance(this.distance).point(this.point);
    }

    public Double getDistance() {
        return this.distance;
    }

    public Position getPoint() {
        return this.point;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DistancePoint)) {
            return false;
        }
        DistancePoint other = (DistancePoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$distance = this.getDistance();
        Double other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        Position this$point = this.getPoint();
        Position other$point = other.getPoint();
        return !(this$point == null ? other$point != null : !this$point.equals(other$point));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DistancePoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        Position $point = this.getPoint();
        result = result * 59 + ($point == null ? 43 : $point.hashCode());
        return result;
    }

    public String toString() {
        return "DistancePoint(distance=" + this.getDistance() + ", point=" + this.getPoint() + ")";
    }

    public static class DistancePointBuilder {
        private Double distance;
        private Position point;

        DistancePointBuilder() {
        }

        public DistancePointBuilder distance(Double distance) {
            this.distance = distance;
            return this;
        }

        public DistancePointBuilder point(Position point) {
            this.point = point;
            return this;
        }

        public DistancePoint build() {
            return new DistancePoint(this.distance, this.point);
        }

        public String toString() {
            return "DistancePoint.DistancePointBuilder(distance=" + this.distance + ", point=" + this.point + ")";
        }
    }
}

