/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash.distance;

import de.alpharogroup.jgeohash.GeoHashPoint;
import de.alpharogroup.jgeohash.api.Position;
import de.alpharogroup.jgeohash.distance.MeasuringUnit;

public final class DistanceCalculator {
    public static double distance(double startLatitude, double startLongitude, double endLatitude, double endLongitude, MeasuringUnit unit) {
        double theta = Math.toRadians(startLongitude - endLongitude);
        double latitudePoint1 = Math.toRadians(startLatitude);
        double latitudePoint2 = Math.toRadians(endLatitude);
        double distance = Math.sin(latitudePoint1) * Math.sin(latitudePoint2) + Math.cos(latitudePoint1) * Math.cos(latitudePoint2) * Math.cos(theta);
        distance = Math.toDegrees(Math.acos(distance)) * 60.0 * 1.1515;
        switch (unit) {
            case MILE: {
                distance *= unit.getFactor();
                break;
            }
            case KILOMETER: {
                distance *= unit.getFactor();
                break;
            }
            case METER: {
                distance *= unit.getFactor();
            }
        }
        return distance;
    }

    public static double distanceBetweenPoints(Position start, Position end, MeasuringUnit unit) {
        double distance = DistanceCalculator.distance(start.getLatitude(), start.getLongitude(), end.getLatitude(), end.getLongitude(), unit);
        return distance;
    }

    public static double distanceBetweenPoints(String startGeohashValue, String endGeohashValue, MeasuringUnit unit) {
        return DistanceCalculator.distanceBetweenPoints(new GeoHashPoint(startGeohashValue), new GeoHashPoint(endGeohashValue), unit);
    }

    private DistanceCalculator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

