/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash;

import de.alpharogroup.jgeohash.api.Position;

public class Point
implements Comparable<Point>,
Cloneable,
Position {
    private static final long serialVersionUID = -4799959551221362673L;
    private double latitude;
    private double longitude;

    public Point(double latitude, double longitude) {
        if (Math.abs(latitude) > 90.0 || Math.abs(longitude) > 180.0) {
            throw new IllegalArgumentException("The given coordinates " + this.toString() + " are out of range.");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Object clone() {
        Point inst = new Point(this.latitude, this.longitude);
        return inst;
    }

    @Override
    public int compareTo(Point other) {
        if (this == other) {
            return 0;
        }
        if (this.latitude < other.latitude) {
            return -1;
        }
        if (this.latitude > other.latitude) {
            return 1;
        }
        if (this.longitude < other.longitude) {
            return -1;
        }
        if (this.longitude > other.longitude) {
            return 1;
        }
        assert (this.equals(other)) : "compareTo inconsistent with equals.";
        return 0;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public void setLatitude(double latitude) {
        if (Math.abs(latitude) > 90.0) {
            throw new IllegalArgumentException("The given coordinates for latitude " + latitude + " are out of range.");
        }
        this.latitude = latitude;
    }

    @Override
    public void setLongitude(double longitude) {
        if (Math.abs(longitude) > 180.0) {
            throw new IllegalArgumentException("The given coordinates for longitude " + longitude + " are out of range.");
        }
        this.longitude = longitude;
    }

    public String toString() {
        return "Latitude : " + this.latitude + "   Longitude  : " + this.longitude;
    }

    public static PointBuilder builder() {
        return new PointBuilder();
    }

    public PointBuilder toBuilder() {
        return new PointBuilder().latitude(this.latitude).longitude(this.longitude);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        return Double.compare(this.getLongitude(), other.getLongitude()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        return result;
    }

    public static class PointBuilder {
        private double latitude;
        private double longitude;

        PointBuilder() {
        }

        public PointBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public PointBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Point build() {
            return new Point(this.latitude, this.longitude);
        }

        public String toString() {
            return "Point.PointBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ")";
        }
    }
}

