/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jgeohash;

import de.alpharogroup.jgeohash.GeoHashExtensions;
import de.alpharogroup.jgeohash.Point;
import de.alpharogroup.jgeohash.api.Position;
import java.math.BigDecimal;

public class GeoHashPoint
extends Point {
    public static final String GEOHASH_KEY = "GEOHASH_KEY";
    private static final long serialVersionUID = -3580536765079661097L;

    public GeoHashPoint(double latitude, double longitude) {
        super(latitude, longitude);
    }

    public GeoHashPoint(Double latitude, Double longitude) {
        super(latitude, longitude);
    }

    public GeoHashPoint(float latitude, float longitude) {
        this(Float.toString(latitude), Float.toString(longitude));
    }

    public GeoHashPoint(Position position) {
        this(position.getLatitude(), position.getLongitude());
    }

    public GeoHashPoint(String geohash) {
        super(GeoHashExtensions.decode(geohash)[0], GeoHashExtensions.decode(geohash)[1]);
    }

    public GeoHashPoint(String lat, String lng) {
        super(Double.parseDouble(lat), Double.parseDouble(lng));
    }

    @Override
    public Object clone() {
        return new GeoHashPoint(this.getLatitude(), this.getLongitude());
    }

    public String getGeohash() {
        return GeoHashExtensions.encode(this.getLatitude(), this.getLongitude());
    }

    public BigDecimal getLat() {
        return BigDecimal.valueOf(this.getLatitude());
    }

    public BigDecimal getLng() {
        return BigDecimal.valueOf(this.getLongitude());
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[GeoHashPoint:");
        buffer.append(super.toString());
        buffer.append("   Geohash : ");
        buffer.append(this.getGeohash());
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoHashPoint)) {
            return false;
        }
        GeoHashPoint other = (GeoHashPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GeoHashPoint;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

