/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner.factories;

import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ConfigurationFactory {
    public static HttpConfiguration newHttpConfiguration(String secureScheme, int securePort, int outputBufferSize) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSecureScheme(secureScheme);
        httpConfiguration.setSecurePort(securePort);
        httpConfiguration.setOutputBufferSize(outputBufferSize);
        return httpConfiguration;
    }

    public static SecureRequestCustomizer newSecureRequestCustomizer(long stsMaxAgeSeconds, boolean stsIncludeSubDomains) {
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(stsMaxAgeSeconds);
        src.setStsIncludeSubDomains(stsIncludeSubDomains);
        return src;
    }

    public static ServerConnector newServerConnector(Server server, HttpConfiguration httpConfiguration, int port, long idleTimeout) {
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
        serverConnector.setPort(port);
        serverConnector.setIdleTimeout(idleTimeout);
        return serverConnector;
    }

    public static ServerConnector newServerConnector(Server server, SslConnectionFactory sslConnectionFactory, HttpConfiguration httpConfiguration, int port, long idleTimeout) {
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpConfiguration)});
        serverConnector.setPort(port);
        serverConnector.setIdleTimeout(idleTimeout);
        return serverConnector;
    }

    public static SslContextFactory newSslContextFactory(Resource keyStoreResource, String keyStorePassword, String keyManagerPassword) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStoreResource(keyStoreResource);
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setKeyManagerPassword(keyManagerPassword);
        return sslContextFactory;
    }

    public static SslContextFactory newSslContextFactory(String keyStorePath, String keyStorePassword, String keyManagerPassword) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setKeyManagerPassword(keyManagerPassword);
        return sslContextFactory;
    }
}

