/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner.config;

import de.alpharogroup.jetty9.runner.config.FilterHolderConfiguration;
import de.alpharogroup.jetty9.runner.config.ServletHolderConfiguration;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.HandlerContainer;

public class ServletContextHandlerConfiguration {
    private Class<?> applicationClass;
    private File webapp;
    private String contextPath;
    private int maxInactiveInterval;
    private String filterPath;
    private List<FilterHolderConfiguration> filterHolderConfigurations;
    private List<ServletHolderConfiguration> servletHolderConfigurations;
    private Map<String, String> initParameters;
    private HandlerContainer parent;

    public static ServletContextHandlerConfigurationBuilder builder() {
        return new ServletContextHandlerConfigurationBuilder();
    }

    public Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    public File getWebapp() {
        return this.webapp;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public List<FilterHolderConfiguration> getFilterHolderConfigurations() {
        return this.filterHolderConfigurations;
    }

    public List<ServletHolderConfiguration> getServletHolderConfigurations() {
        return this.servletHolderConfigurations;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public HandlerContainer getParent() {
        return this.parent;
    }

    public void setApplicationClass(Class<?> applicationClass) {
        this.applicationClass = applicationClass;
    }

    public void setWebapp(File webapp) {
        this.webapp = webapp;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public void setFilterHolderConfigurations(List<FilterHolderConfiguration> filterHolderConfigurations) {
        this.filterHolderConfigurations = filterHolderConfigurations;
    }

    public void setServletHolderConfigurations(List<ServletHolderConfiguration> servletHolderConfigurations) {
        this.servletHolderConfigurations = servletHolderConfigurations;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = initParameters;
    }

    public void setParent(HandlerContainer parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServletContextHandlerConfiguration)) {
            return false;
        }
        ServletContextHandlerConfiguration other = (ServletContextHandlerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$applicationClass = this.getApplicationClass();
        Class<?> other$applicationClass = other.getApplicationClass();
        if (this$applicationClass == null ? other$applicationClass != null : !this$applicationClass.equals(other$applicationClass)) {
            return false;
        }
        File this$webapp = this.getWebapp();
        File other$webapp = other.getWebapp();
        if (this$webapp == null ? other$webapp != null : !((Object)this$webapp).equals(other$webapp)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
            return false;
        }
        if (this.getMaxInactiveInterval() != other.getMaxInactiveInterval()) {
            return false;
        }
        String this$filterPath = this.getFilterPath();
        String other$filterPath = other.getFilterPath();
        if (this$filterPath == null ? other$filterPath != null : !this$filterPath.equals(other$filterPath)) {
            return false;
        }
        List<FilterHolderConfiguration> this$filterHolderConfigurations = this.getFilterHolderConfigurations();
        List<FilterHolderConfiguration> other$filterHolderConfigurations = other.getFilterHolderConfigurations();
        if (this$filterHolderConfigurations == null ? other$filterHolderConfigurations != null : !((Object)this$filterHolderConfigurations).equals(other$filterHolderConfigurations)) {
            return false;
        }
        List<ServletHolderConfiguration> this$servletHolderConfigurations = this.getServletHolderConfigurations();
        List<ServletHolderConfiguration> other$servletHolderConfigurations = other.getServletHolderConfigurations();
        if (this$servletHolderConfigurations == null ? other$servletHolderConfigurations != null : !((Object)this$servletHolderConfigurations).equals(other$servletHolderConfigurations)) {
            return false;
        }
        Map<String, String> this$initParameters = this.getInitParameters();
        Map<String, String> other$initParameters = other.getInitParameters();
        if (this$initParameters == null ? other$initParameters != null : !((Object)this$initParameters).equals(other$initParameters)) {
            return false;
        }
        HandlerContainer this$parent = this.getParent();
        HandlerContainer other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServletContextHandlerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $applicationClass = this.getApplicationClass();
        result = result * 59 + ($applicationClass == null ? 43 : $applicationClass.hashCode());
        File $webapp = this.getWebapp();
        result = result * 59 + ($webapp == null ? 43 : ((Object)$webapp).hashCode());
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        result = result * 59 + this.getMaxInactiveInterval();
        String $filterPath = this.getFilterPath();
        result = result * 59 + ($filterPath == null ? 43 : $filterPath.hashCode());
        List<FilterHolderConfiguration> $filterHolderConfigurations = this.getFilterHolderConfigurations();
        result = result * 59 + ($filterHolderConfigurations == null ? 43 : ((Object)$filterHolderConfigurations).hashCode());
        List<ServletHolderConfiguration> $servletHolderConfigurations = this.getServletHolderConfigurations();
        result = result * 59 + ($servletHolderConfigurations == null ? 43 : ((Object)$servletHolderConfigurations).hashCode());
        Map<String, String> $initParameters = this.getInitParameters();
        result = result * 59 + ($initParameters == null ? 43 : ((Object)$initParameters).hashCode());
        HandlerContainer $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    public String toString() {
        return "ServletContextHandlerConfiguration(applicationClass=" + this.getApplicationClass() + ", webapp=" + this.getWebapp() + ", contextPath=" + this.getContextPath() + ", maxInactiveInterval=" + this.getMaxInactiveInterval() + ", filterPath=" + this.getFilterPath() + ", filterHolderConfigurations=" + this.getFilterHolderConfigurations() + ", servletHolderConfigurations=" + this.getServletHolderConfigurations() + ", initParameters=" + this.getInitParameters() + ", parent=" + this.getParent() + ")";
    }

    public ServletContextHandlerConfiguration() {
    }

    @ConstructorProperties(value={"applicationClass", "webapp", "contextPath", "maxInactiveInterval", "filterPath", "filterHolderConfigurations", "servletHolderConfigurations", "initParameters", "parent"})
    public ServletContextHandlerConfiguration(Class<?> applicationClass, File webapp, String contextPath, int maxInactiveInterval, String filterPath, List<FilterHolderConfiguration> filterHolderConfigurations, List<ServletHolderConfiguration> servletHolderConfigurations, Map<String, String> initParameters, HandlerContainer parent) {
        this.applicationClass = applicationClass;
        this.webapp = webapp;
        this.contextPath = contextPath;
        this.maxInactiveInterval = maxInactiveInterval;
        this.filterPath = filterPath;
        this.filterHolderConfigurations = filterHolderConfigurations;
        this.servletHolderConfigurations = servletHolderConfigurations;
        this.initParameters = initParameters;
        this.parent = parent;
    }

    public static class ServletContextHandlerConfigurationBuilder {
        private Class<?> applicationClass;
        private File webapp;
        private String contextPath;
        private int maxInactiveInterval;
        private String filterPath;
        private ArrayList<FilterHolderConfiguration> filterHolderConfigurations;
        private ArrayList<ServletHolderConfiguration> servletHolderConfigurations;
        private ArrayList<String> initParameters$key;
        private ArrayList<String> initParameters$value;
        private HandlerContainer parent;

        ServletContextHandlerConfigurationBuilder() {
        }

        public ServletContextHandlerConfigurationBuilder applicationClass(Class<?> applicationClass) {
            this.applicationClass = applicationClass;
            return this;
        }

        public ServletContextHandlerConfigurationBuilder webapp(File webapp) {
            this.webapp = webapp;
            return this;
        }

        public ServletContextHandlerConfigurationBuilder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public ServletContextHandlerConfigurationBuilder maxInactiveInterval(int maxInactiveInterval) {
            this.maxInactiveInterval = maxInactiveInterval;
            return this;
        }

        public ServletContextHandlerConfigurationBuilder filterPath(String filterPath) {
            this.filterPath = filterPath;
            return this;
        }

        public ServletContextHandlerConfigurationBuilder filterHolderConfiguration(FilterHolderConfiguration filterHolderConfiguration) {
            if (this.filterHolderConfigurations == null) {
                this.filterHolderConfigurations = new ArrayList();
            }
            this.filterHolderConfigurations.add(filterHolderConfiguration);
            return this;
        }

        public ServletContextHandlerConfigurationBuilder filterHolderConfigurations(Collection<? extends FilterHolderConfiguration> filterHolderConfigurations) {
            if (this.filterHolderConfigurations == null) {
                this.filterHolderConfigurations = new ArrayList();
            }
            this.filterHolderConfigurations.addAll(filterHolderConfigurations);
            return this;
        }

        public ServletContextHandlerConfigurationBuilder servletHolderConfiguration(ServletHolderConfiguration servletHolderConfiguration) {
            if (this.servletHolderConfigurations == null) {
                this.servletHolderConfigurations = new ArrayList();
            }
            this.servletHolderConfigurations.add(servletHolderConfiguration);
            return this;
        }

        public ServletContextHandlerConfigurationBuilder servletHolderConfigurations(Collection<? extends ServletHolderConfiguration> servletHolderConfigurations) {
            if (this.servletHolderConfigurations == null) {
                this.servletHolderConfigurations = new ArrayList();
            }
            this.servletHolderConfigurations.addAll(servletHolderConfigurations);
            return this;
        }

        public ServletContextHandlerConfigurationBuilder initParameter(String initParameterKey, String initParameterValue) {
            if (this.initParameters$key == null) {
                this.initParameters$key = new ArrayList();
                this.initParameters$value = new ArrayList();
            }
            this.initParameters$key.add(initParameterKey);
            this.initParameters$value.add(initParameterValue);
            return this;
        }

        public ServletContextHandlerConfigurationBuilder initParameters(Map<? extends String, ? extends String> initParameters) {
            if (this.initParameters$key == null) {
                this.initParameters$key = new ArrayList();
                this.initParameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : initParameters.entrySet()) {
                this.initParameters$key.add($lombokEntry.getKey());
                this.initParameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ServletContextHandlerConfigurationBuilder parent(HandlerContainer parent) {
            this.parent = parent;
            return this;
        }

        public ServletContextHandlerConfiguration build() {
            Map<String, String> initParameters;
            List<ServletHolderConfiguration> servletHolderConfigurations;
            List<FilterHolderConfiguration> filterHolderConfigurations;
            switch (this.filterHolderConfigurations == null ? 0 : this.filterHolderConfigurations.size()) {
                case 0: {
                    filterHolderConfigurations = Collections.emptyList();
                    break;
                }
                case 1: {
                    filterHolderConfigurations = Collections.singletonList(this.filterHolderConfigurations.get(0));
                    break;
                }
                default: {
                    filterHolderConfigurations = Collections.unmodifiableList(new ArrayList<FilterHolderConfiguration>(this.filterHolderConfigurations));
                }
            }
            switch (this.servletHolderConfigurations == null ? 0 : this.servletHolderConfigurations.size()) {
                case 0: {
                    servletHolderConfigurations = Collections.emptyList();
                    break;
                }
                case 1: {
                    servletHolderConfigurations = Collections.singletonList(this.servletHolderConfigurations.get(0));
                    break;
                }
                default: {
                    servletHolderConfigurations = Collections.unmodifiableList(new ArrayList<ServletHolderConfiguration>(this.servletHolderConfigurations));
                }
            }
            switch (this.initParameters$key == null ? 0 : this.initParameters$key.size()) {
                case 0: {
                    initParameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    initParameters = Collections.singletonMap(this.initParameters$key.get(0), this.initParameters$value.get(0));
                    break;
                }
                default: {
                    initParameters = new LinkedHashMap(this.initParameters$key.size() < 0x40000000 ? 1 + this.initParameters$key.size() + (this.initParameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.initParameters$key.size(); ++$i) {
                        initParameters.put(this.initParameters$key.get($i), this.initParameters$value.get($i));
                    }
                    initParameters = Collections.unmodifiableMap(initParameters);
                }
            }
            return new ServletContextHandlerConfiguration(this.applicationClass, this.webapp, this.contextPath, this.maxInactiveInterval, this.filterPath, filterHolderConfigurations, servletHolderConfigurations, initParameters, this.parent);
        }

        public String toString() {
            return "ServletContextHandlerConfiguration.ServletContextHandlerConfigurationBuilder(applicationClass=" + this.applicationClass + ", webapp=" + this.webapp + ", contextPath=" + this.contextPath + ", maxInactiveInterval=" + this.maxInactiveInterval + ", filterPath=" + this.filterPath + ", filterHolderConfigurations=" + this.filterHolderConfigurations + ", servletHolderConfigurations=" + this.servletHolderConfigurations + ", initParameters$key=" + this.initParameters$key + ", initParameters$value=" + this.initParameters$value + ", parent=" + this.parent + ")";
        }
    }
}

