/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.util;

import de.alpharogroup.lang.ClassExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LocalTime lastModified;
    private Manifest manifest;
    private String title;
    private String version;

    public static ManifestVersion get(Class<?> clazz) {
        String manifestUrl = ClassExtensions.getManifestUrl(clazz);
        try {
            return ManifestVersion.of(manifestUrl != null ? new URL(manifestUrl) : null);
        }
        catch (MalformedURLException ignore) {
            return ManifestVersion.of(null);
        }
    }

    private static ManifestVersion of(URL url) {
        ManifestVersion version = new ManifestVersion();
        if (url != null) {
            URLConnection urlConnection = null;
            try {
                urlConnection = url.openConnection();
                version.setLastModified(Instant.ofEpochMilli(urlConnection.getLastModified()).atZone(ZoneId.systemDefault()).toLocalTime());
                version.setManifest(new Manifest(urlConnection.getInputStream()));
                version.setTitle(version.getManifestAttribute(Attributes.Name.IMPLEMENTATION_TITLE));
                version.setVersion(version.getManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION));
            }
            catch (IOException e) {
                throw new RuntimeException("Error while try to load manifest file from " + url, e);
            }
        }
        return version;
    }

    public String getManifestAttribute(Attributes.Name name) {
        Attributes attributes;
        Object value;
        if (this.getManifest() != null && (value = (attributes = this.getManifest().getMainAttributes()).get(name)) != null) {
            return value.toString().trim();
        }
        return "";
    }

    public LocalTime getLastModified() {
        return this.lastModified;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setLastModified(LocalTime lastModified) {
        this.lastModified = lastModified;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManifestVersion)) {
            return false;
        }
        ManifestVersion other = (ManifestVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalTime this$lastModified = this.getLastModified();
        LocalTime other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified)) {
            return false;
        }
        Manifest this$manifest = this.getManifest();
        Manifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ManifestVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalTime $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        Manifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public String toString() {
        return "ManifestVersion(lastModified=" + this.getLastModified() + ", manifest=" + this.getManifest() + ", title=" + this.getTitle() + ", version=" + this.getVersion() + ")";
    }
}

