/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.thread;

public class ThreadDataBean {
    private boolean alive;
    private boolean daemon;
    private boolean interrupted;
    private String name;
    private Integer priority;
    private String threadGroup;

    public static ThreadDataBean of(Thread thread) {
        return ThreadDataBean.builder().priority(thread.getPriority()).alive(thread.isAlive()).daemon(thread.isDaemon()).interrupted(thread.isInterrupted()).threadGroup(thread.getThreadGroup().getName()).name(thread.getName()).build();
    }

    public static ThreadDataBeanBuilder builder() {
        return new ThreadDataBeanBuilder();
    }

    public ThreadDataBeanBuilder toBuilder() {
        return new ThreadDataBeanBuilder().alive(this.alive).daemon(this.daemon).interrupted(this.interrupted).name(this.name).priority(this.priority).threadGroup(this.threadGroup);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getThreadGroup() {
        return this.threadGroup;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setThreadGroup(String threadGroup) {
        this.threadGroup = threadGroup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadDataBean)) {
            return false;
        }
        ThreadDataBean other = (ThreadDataBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAlive() != other.isAlive()) {
            return false;
        }
        if (this.isDaemon() != other.isDaemon()) {
            return false;
        }
        if (this.isInterrupted() != other.isInterrupted()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$threadGroup = this.getThreadGroup();
        String other$threadGroup = other.getThreadGroup();
        return !(this$threadGroup == null ? other$threadGroup != null : !this$threadGroup.equals(other$threadGroup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadDataBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlive() ? 79 : 97);
        result = result * 59 + (this.isDaemon() ? 79 : 97);
        result = result * 59 + (this.isInterrupted() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $threadGroup = this.getThreadGroup();
        result = result * 59 + ($threadGroup == null ? 43 : $threadGroup.hashCode());
        return result;
    }

    public String toString() {
        return "ThreadDataBean(alive=" + this.isAlive() + ", daemon=" + this.isDaemon() + ", interrupted=" + this.isInterrupted() + ", name=" + this.getName() + ", priority=" + this.getPriority() + ", threadGroup=" + this.getThreadGroup() + ")";
    }

    public ThreadDataBean() {
    }

    public ThreadDataBean(boolean alive, boolean daemon, boolean interrupted, String name, Integer priority, String threadGroup) {
        this.alive = alive;
        this.daemon = daemon;
        this.interrupted = interrupted;
        this.name = name;
        this.priority = priority;
        this.threadGroup = threadGroup;
    }

    public static class ThreadDataBeanBuilder {
        private boolean alive;
        private boolean daemon;
        private boolean interrupted;
        private String name;
        private Integer priority;
        private String threadGroup;

        ThreadDataBeanBuilder() {
        }

        public ThreadDataBeanBuilder alive(boolean alive) {
            this.alive = alive;
            return this;
        }

        public ThreadDataBeanBuilder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public ThreadDataBeanBuilder interrupted(boolean interrupted) {
            this.interrupted = interrupted;
            return this;
        }

        public ThreadDataBeanBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ThreadDataBeanBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public ThreadDataBeanBuilder threadGroup(String threadGroup) {
            this.threadGroup = threadGroup;
            return this;
        }

        public ThreadDataBean build() {
            return new ThreadDataBean(this.alive, this.daemon, this.interrupted, this.name, this.priority, this.threadGroup);
        }

        public String toString() {
            return "ThreadDataBean.ThreadDataBeanBuilder(alive=" + this.alive + ", daemon=" + this.daemon + ", interrupted=" + this.interrupted + ", name=" + this.name + ", priority=" + this.priority + ", threadGroup=" + this.threadGroup + ")";
        }
    }
}

