/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.io.annotations;

import de.alpharogroup.io.annotations.ImportResource;
import de.alpharogroup.io.annotations.ImportResourceComparator;
import de.alpharogroup.io.annotations.ImportResources;
import de.alpharogroup.lang.AnnotationExtensions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public final class ImportResourcesExtensions {
    public static Map<Class<?>, ImportResource[]> getImportResources(String packageName) throws ClassNotFoundException, IOException, URISyntaxException {
        LinkedHashMap resourcesMap = new LinkedHashMap();
        Class<ImportResources> importResourcesClass = ImportResources.class;
        Class<ImportResource> importResourceClass = ImportResource.class;
        Set<Class<?>> importResourcesClasses = AnnotationExtensions.getAllAnnotatedClasses(packageName, importResourcesClass);
        Set<Class<?>> importResourceClasses = AnnotationExtensions.getAllAnnotatedClasses(packageName, importResourceClass);
        importResourcesClasses.addAll(importResourceClasses);
        for (Class<?> annotatedClass : importResourcesClasses) {
            ImportResource importResource;
            ImportResources importResources = annotatedClass.getAnnotation(ImportResources.class);
            Object[] importResourcesArray = null;
            Object[] importResourceArray = null;
            if (importResources != null) {
                importResourcesArray = importResources.resources();
            }
            if ((importResource = annotatedClass.getAnnotation(ImportResource.class)) != null) {
                importResourceArray = new ImportResource[]{importResource};
            }
            ImportResource[] array = (ImportResource[])ArrayUtils.addAll((Object[])importResourceArray, (Object[])importResourcesArray);
            Arrays.sort(array, new ImportResourceComparator());
            resourcesMap.put(annotatedClass, array);
        }
        return resourcesMap;
    }

    private ImportResourcesExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

