/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public final class StreamExtensions
implements Serializable {
    private static final long serialVersionUID = 5042445056004440533L;

    public static byte[] getByteArray(InputStream in) throws IOException {
        return StreamExtensions.getByteArray(in, new ByteArrayOutputStream(in.available()));
    }

    public static byte[] getByteArray(InputStream in, ByteArrayOutputStream os) throws IOException {
        int byt;
        while ((byt = in.read()) != -1) {
            os.write(byt);
        }
        return os.toByteArray();
    }

    public static InputStream getInputStream(File file) throws IOException {
        return StreamExtensions.getInputStream(file, false);
    }

    public static InputStream getInputStream(File file, boolean createFile) throws IOException {
        InputStream is = null;
        if (file.exists()) {
            is = file.toURI().toURL().openStream();
        } else if (createFile) {
            file.createNewFile();
            is = file.toURI().toURL().openStream();
        } else {
            throw new FileNotFoundException("File " + file.getName() + " does not exist.");
        }
        return is;
    }

    public static OutputStream getOutputStream(File file) throws IOException {
        return StreamExtensions.getOutputStream(file, false);
    }

    public static OutputStream getOutputStream(File file, boolean createFile) throws IOException {
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        if (file.exists()) {
            os = new FileOutputStream(file);
        } else if (createFile) {
            file.createNewFile();
            os = new FileOutputStream(file);
        } else {
            throw new FileNotFoundException("File " + file.getName() + " does not exist.");
        }
        bos = new BufferedOutputStream(os);
        return bos;
    }

    public static Reader getReader(File inputFile) throws IOException {
        return StreamExtensions.getReader(inputFile, null, false);
    }

    public static Reader getReader(File inputFile, String encoding, boolean createFile) throws IOException {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        if (inputFile.exists()) {
            fis = new FileInputStream(inputFile);
        } else if (createFile) {
            inputFile.createNewFile();
            fis = new FileInputStream(inputFile);
        } else {
            throw new FileNotFoundException("File " + inputFile.getName() + " does not exist.");
        }
        isr = null == encoding ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, encoding);
        reader = new BufferedReader(isr);
        return reader;
    }

    public static long getSerialVersionUID(Class<? extends Serializable> clazz) {
        return ObjectStreamClass.lookup(clazz).getSerialVersionUID();
    }

    public static Writer getWriter(File file) throws IOException {
        return StreamExtensions.getWriter(file, null, false);
    }

    public static Writer getWriter(File file, String encoding, boolean createFile) throws IOException {
        PrintWriter printWriter = null;
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        if (file.exists()) {
            fos = new FileOutputStream(file);
        } else if (createFile) {
            file.createNewFile();
            fos = new FileOutputStream(file);
        } else {
            throw new FileNotFoundException("File " + file.getName() + "does not exist.");
        }
        bos = new BufferedOutputStream(fos);
        osw = null == encoding ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, encoding);
        printWriter = new PrintWriter(osw);
        return printWriter;
    }

    public static void writeInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int byt;
        while ((byt = inputStream.read()) != -1) {
            outputStream.write(byt);
        }
    }

    private StreamExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

