/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.util;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.lang.util.ManifestVersion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ManifestVersionFactory {
    public static ManifestVersion get(Class<?> clazz) {
        String manifestUrl = ClassExtensions.getManifestUrl(clazz);
        try {
            return ManifestVersionFactory.of(manifestUrl != null ? new URL(manifestUrl) : null);
        }
        catch (MalformedURLException ignore) {
            return ManifestVersionFactory.of(null);
        }
    }

    public static ManifestVersion of(URL url) {
        ManifestVersion version = new ManifestVersion();
        if (url != null) {
            URLConnection urlConnection = null;
            try {
                urlConnection = url.openConnection();
                version.setLastModified(LocalDateTime.ofInstant(Instant.ofEpochMilli(urlConnection.getLastModified()), ZoneId.systemDefault()));
                version.setManifest(new Manifest(urlConnection.getInputStream()));
                version.setTitle(version.getManifestAttribute(Attributes.Name.IMPLEMENTATION_TITLE));
                version.setVersion(version.getManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION));
            }
            catch (IOException e) {
                throw new RuntimeException("Error while try to load manifest file from " + url, e);
            }
        }
        return version;
    }

    private ManifestVersionFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

