/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.io.file.FileExtension;
import de.alpharogroup.io.file.FilenameExtensions;
import de.alpharogroup.io.file.filter.ClassFileFilter;
import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.lang.ScanPackageExtensions;
import de.alpharogroup.string.StringExtensions;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class ScanClassExtensions {
    public static boolean equalsByClassName(Class<?> oneClass, Class<?> otherClass) {
        String oneNormalizedClassName = ScanClassExtensions.normalizeQualifiedClassName(oneClass.getName());
        String otherNormalizedClassName = ScanClassExtensions.normalizeQualifiedClassName(otherClass.getName());
        return otherNormalizedClassName.equals(oneNormalizedClassName);
    }

    public static String normalizeQualifiedClassName(String qualifiedClassname) {
        return ScanClassExtensions.normalizeSimpleClassName(qualifiedClassname).replaceAll("/", ".");
    }

    public static String normalizeSimpleClassName(String className) {
        int lastIndexOf$;
        String result = className;
        if (className.endsWith(FileExtension.CLASS.getExtension())) {
            result = StringExtensions.replaceLast((String)className, (String)FileExtension.CLASS.getExtension(), (String)"");
        }
        if ((lastIndexOf$ = result.lastIndexOf("$")) != -1) {
            String prefix = result.substring(0, lastIndexOf$);
            String compilerClassName = result.substring(lastIndexOf$ + 1, result.length());
            if (StringUtils.isNumeric((CharSequence)compilerClassName)) {
                return prefix;
            }
        }
        return result;
    }

    public static Set<Class<?>> scanClassesFromPackage(File directory, String packagePath) throws ClassNotFoundException {
        return ScanClassExtensions.scanClassesFromPackage(directory, packagePath, false);
    }

    public static Set<Class<?>> scanClassesFromPackage(File directory, String packagePath, boolean recursive) throws ClassNotFoundException {
        File[] files;
        LinkedHashSet foundClasses = new LinkedHashSet();
        if (!directory.exists()) {
            return foundClasses;
        }
        ClassFileFilter includeFileFilter = new ClassFileFilter();
        for (File file : files = directory.listFiles((FileFilter)includeFileFilter)) {
            String qualifiedClassname = null;
            if (file.isDirectory() && recursive) {
                qualifiedClassname = packagePath + "." + file.getName();
                foundClasses.addAll(ScanClassExtensions.scanClassesFromPackage(file, qualifiedClassname, recursive));
                continue;
            }
            if (file.isDirectory()) continue;
            String filename = FilenameExtensions.getFilenameWithoutExtension((File)file);
            qualifiedClassname = packagePath + '.' + filename;
            foundClasses.add(ClassExtensions.forName((String)qualifiedClassname));
        }
        return foundClasses;
    }

    public static Set<Class<?>> scanClassNames(String packageName) throws IOException, ClassNotFoundException {
        return ScanClassExtensions.scanClassNames(packageName, false);
    }

    public static Set<Class<?>> scanClassNames(String packageName, boolean recursive) throws IOException, ClassNotFoundException {
        LinkedHashSet foundClasses = new LinkedHashSet();
        Set<String> qualifiedClassnames = ScanPackageExtensions.scanClassNames(packageName, recursive, true);
        for (String qualifiedClassname : qualifiedClassnames) {
            foundClasses.add(ClassExtensions.forName((String)qualifiedClassname));
        }
        return foundClasses;
    }

    private ScanClassExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

