/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.config;

import java.io.File;
import lombok.NonNull;

public final class ConfigurationExtensions {
    public static final String USER_HOME_PROPERTY_KEY = "user.home";
    public static final String JAVA_IO_TPMDIR_PROPERTY_KEY = "java.io.tmpdir";

    public static String getUserApplicationConfigurationFilePath(@NonNull String applicationName, @NonNull String configFileName) {
        if (applicationName == null) {
            throw new NullPointerException("applicationName is marked @NonNull but is null");
        }
        if (configFileName == null) {
            throw new NullPointerException("configFileName is marked @NonNull but is null");
        }
        return System.getProperty(USER_HOME_PROPERTY_KEY) + File.separator + applicationName + File.separator + configFileName;
    }

    public static String getTemporaryApplicationConfigurationFilePath(@NonNull String applicationName, @NonNull String fileName) {
        if (applicationName == null) {
            throw new NullPointerException("applicationName is marked @NonNull but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked @NonNull but is null");
        }
        return System.getProperty(JAVA_IO_TPMDIR_PROPERTY_KEY) + File.separator + applicationName + File.separator + fileName;
    }

    private ConfigurationExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

