/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.check.Check;
import de.alpharogroup.lang.ClassExtensions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeArgumentsExtensions {
    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeArgumentsExtensions.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = TypeArgumentsExtensions.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> Class<?> getFirstTypeArgument(Class<T> baseClass, Class<? extends T> childClass) {
        return TypeArgumentsExtensions.getTypeArgument(baseClass, childClass, 0);
    }

    public static <T> Class<?> getTypeArgument(Class<T> baseClass, Class<? extends T> childClass, int index) {
        List<Class<?>> typeArguments = TypeArgumentsExtensions.getTypeArguments(baseClass, childClass);
        if (typeArguments != null && !typeArguments.isEmpty() && index < typeArguments.size()) {
            return typeArguments.get(index);
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<? extends T> childClass) {
        Check.get().notNull(childClass, "childClass");
        Class<?> baseClass = ClassExtensions.getBaseClass(childClass);
        return TypeArgumentsExtensions.getTypeArguments(baseClass, childClass);
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        Check.get().notNull(baseClass, "baseClass").notNull(childClass, "childClass");
        Class<Object> realBaseClass = baseClass;
        if (realBaseClass.isInterface()) {
            realBaseClass = ClassExtensions.getBaseClass(childClass);
        }
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        Type type = childClass;
        while (!TypeArgumentsExtensions.getClass(type).equals(realBaseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            resolvedTypes.putAll(TypeArgumentsExtensions.getTypeArgumentsAndParameters(type));
            if (rawType.equals(realBaseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(TypeArgumentsExtensions.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    private static Map<Type, Type> getTypeArgumentsAndParameters(Type type) {
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class rawType = (Class)parameterizedType.getRawType();
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
        }
        return resolvedTypes;
    }
}

