/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class StringOutputStream
extends OutputStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private Charset charset;

    @Override
    public void close() throws IOException {
        this.byteBuffer.close();
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = Charset.forName("UTF-8");
        }
        return this.charset;
    }

    public String toString() {
        return new String(this.byteBuffer.toByteArray(), this.getCharset());
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.byteBuffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.byteBuffer.write(b, off, len);
    }

    @Override
    public void write(int b) {
        this.byteBuffer.write(b);
    }

    public void write(String value) throws IOException {
        this.write(value.getBytes());
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

