/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.object;

import de.alpharogroup.io.SerializedObjectExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

@Deprecated
public final class CloneObjectExtensions {
    private static final Logger LOG = Logger.getLogger((String)CloneObjectExtensions.class.getName());

    public static <T> T clone(T object) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        return (T)CloneObjectExtensions.cloneObject(object);
    }

    public static <T> T cloneQuietly(T object) {
        return (T)CloneObjectExtensions.cloneObjectQuietly(object);
    }

    public static Object cloneObject(Object object) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        Object clone = null;
        if (object instanceof Serializable && (clone = SerializedObjectExtensions.copySerializedObject((Serializable)object)) != null) {
            return clone;
        }
        if (clone == null && object instanceof Cloneable) {
            Class<?> clazz;
            Method cloneMethod;
            if (object.getClass().isArray()) {
                Class<?> componentType = object.getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    int length = Array.getLength(object);
                    clone = Array.newInstance(componentType, length);
                    while (length-- > 0) {
                        Array.set(clone, length, Array.get(object, length));
                    }
                } else {
                    clone = ((Object[])object).clone();
                }
                if (clone != null) {
                    return clone;
                }
            }
            if ((clone = (cloneMethod = (clazz = object.getClass()).getMethod("clone", null)).invoke(object, (Object[])null)) != null) {
                return clone;
            }
        }
        if (clone == null) {
            clone = ReflectionExtensions.newInstance(object);
            BeanUtils.copyProperties((Object)clone, (Object)object);
        }
        return clone;
    }

    public static Object cloneObjectQuietly(Object object) {
        Object clone = null;
        try {
            clone = CloneObjectExtensions.cloneObject(object);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Try to clone the object with reflection and call the clone method. Thrown exception: NoSuchMethodException", (Throwable)e);
        }
        catch (SecurityException e) {
            LOG.error((Object)"Try to clone the object with reflection and call the clone method. Thrown exception: SecurityException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of IllegalAccessException. Could not found from ReflectionExtensions.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Try to clone the object with reflection and call the clone method. Thrown exception: IllegalArgumentException", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of InvocationTargetException. Could not found from ReflectionExtensions.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of ClassNotFoundException. Could not found from ReflectionExtensions.", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Try to clone the object with org.apache.commons.beanutils.BeanUtils failed cause of InstantiationException. Could not found from ReflectionExtensions.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Try to clone the object with SerializedObjectUtils.copySerializedObject((Serializable)object) cause of IOException.", (Throwable)e);
        }
        return clone;
    }

    private CloneObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

