/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.thread;

import java.beans.ConstructorProperties;

public class ThreadDataBean {
    private Integer priority;
    private boolean alive;
    private boolean daemon;
    private boolean interrupted;
    private String threadGroup;
    private String name;

    public static ThreadDataBean of(Thread thread) {
        return ThreadDataBean.builder().priority(thread.getPriority()).alive(thread.isAlive()).daemon(thread.isDaemon()).interrupted(thread.isInterrupted()).threadGroup(thread.getThreadGroup().getName()).name(thread.getName()).build();
    }

    public static ThreadDataBeanBuilder builder() {
        return new ThreadDataBeanBuilder();
    }

    public ThreadDataBeanBuilder toBuilder() {
        return new ThreadDataBeanBuilder().priority(this.priority).alive(this.alive).daemon(this.daemon).interrupted(this.interrupted).threadGroup(this.threadGroup).name(this.name);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public String getThreadGroup() {
        return this.threadGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public void setThreadGroup(String threadGroup) {
        this.threadGroup = threadGroup;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadDataBean)) {
            return false;
        }
        ThreadDataBean other = (ThreadDataBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        if (this.isAlive() != other.isAlive()) {
            return false;
        }
        if (this.isDaemon() != other.isDaemon()) {
            return false;
        }
        if (this.isInterrupted() != other.isInterrupted()) {
            return false;
        }
        String this$threadGroup = this.getThreadGroup();
        String other$threadGroup = other.getThreadGroup();
        if (this$threadGroup == null ? other$threadGroup != null : !this$threadGroup.equals(other$threadGroup)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadDataBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        result = result * 59 + (this.isAlive() ? 79 : 97);
        result = result * 59 + (this.isDaemon() ? 79 : 97);
        result = result * 59 + (this.isInterrupted() ? 79 : 97);
        String $threadGroup = this.getThreadGroup();
        result = result * 59 + ($threadGroup == null ? 43 : $threadGroup.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "ThreadDataBean(priority=" + this.getPriority() + ", alive=" + this.isAlive() + ", daemon=" + this.isDaemon() + ", interrupted=" + this.isInterrupted() + ", threadGroup=" + this.getThreadGroup() + ", name=" + this.getName() + ")";
    }

    public ThreadDataBean() {
    }

    @ConstructorProperties(value={"priority", "alive", "daemon", "interrupted", "threadGroup", "name"})
    public ThreadDataBean(Integer priority, boolean alive, boolean daemon, boolean interrupted, String threadGroup, String name) {
        this.priority = priority;
        this.alive = alive;
        this.daemon = daemon;
        this.interrupted = interrupted;
        this.threadGroup = threadGroup;
        this.name = name;
    }

    public static class ThreadDataBeanBuilder {
        private Integer priority;
        private boolean alive;
        private boolean daemon;
        private boolean interrupted;
        private String threadGroup;
        private String name;

        ThreadDataBeanBuilder() {
        }

        public ThreadDataBeanBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public ThreadDataBeanBuilder alive(boolean alive) {
            this.alive = alive;
            return this;
        }

        public ThreadDataBeanBuilder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public ThreadDataBeanBuilder interrupted(boolean interrupted) {
            this.interrupted = interrupted;
            return this;
        }

        public ThreadDataBeanBuilder threadGroup(String threadGroup) {
            this.threadGroup = threadGroup;
            return this;
        }

        public ThreadDataBeanBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ThreadDataBean build() {
            return new ThreadDataBean(this.priority, this.alive, this.daemon, this.interrupted, this.threadGroup, this.name);
        }

        public String toString() {
            return "ThreadDataBean.ThreadDataBeanBuilder(priority=" + this.priority + ", alive=" + this.alive + ", daemon=" + this.daemon + ", interrupted=" + this.interrupted + ", threadGroup=" + this.threadGroup + ", name=" + this.name + ")";
        }
    }
}

