/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.reflection;

import de.alpharogroup.string.StringExtensions;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReflectionExtensions {
    public static List<String> getFieldNames(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public static String[] getMethodNames(Class<?> cls) {
        Method[] methods = cls.getDeclaredMethods();
        String[] methodNames = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodNames[i] = methods[i].getName();
        }
        return methodNames;
    }

    public static final Map<String, String> getMethodNamesWithPrefixFromFieldNames(List<String> fieldNames, String prefix) {
        HashMap<String, String> fieldNameMethodMapper = new HashMap<String, String>();
        for (String fieldName : fieldNames) {
            String firstCharacterToUpperCasefieldName = StringExtensions.firstCharacterToUpperCase(fieldName);
            String methodName = prefix + firstCharacterToUpperCasefieldName;
            fieldNameMethodMapper.put(fieldName, methodName);
        }
        return fieldNameMethodMapper;
    }

    public static List<String> getModifiers(Field field) {
        String modifiers = Modifier.toString(field.getModifiers());
        String[] modifiersArray = modifiers.split(" ");
        return Arrays.asList(modifiersArray);
    }

    @Deprecated
    public static <T> T getNewInstance(T obj) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ReflectionExtensions.newInstance(obj);
    }

    public static <T> T newInstance(T obj) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (T)ReflectionExtensions.newInstance(Class.forName(obj.getClass().getCanonicalName()));
    }

    public static <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return clazz.newInstance();
    }

    public static <T> Field getDeclaredField(T object, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field = object.getClass().getDeclaredField(fieldName);
        return field;
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field = cls.getDeclaredField(fieldName);
        return field;
    }

    private ReflectionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

