/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.math;

public class MathExtensions {
    public static int[] getPrimeNumbers(int quantity) {
        int[] primes = new int[quantity];
        int i = 0;
        int number = 2;
        while (i < quantity) {
            boolean isPrime = MathExtensions.isPrime(number);
            if (isPrime) {
                primes[i++] = number;
            }
            ++number;
        }
        return primes;
    }

    public static boolean isBetween(int min, int max, int index) {
        return min < index && index < max;
    }

    public static boolean isInRange(int min, int max, int number) {
        return MathExtensions.isBetween(min, max, number);
    }

    public static boolean isNegative(double number) {
        return !MathExtensions.isPositive(number);
    }

    public static boolean isNegative(int number) {
        return !MathExtensions.isPositive(number);
    }

    public static boolean isNegative(long number) {
        return !MathExtensions.isPositive(number);
    }

    public static boolean isNext(Integer number, Integer nextNumber) {
        int next = number + 1;
        return next == nextNumber;
    }

    public static boolean isPositive(double number) {
        boolean positive = false;
        if (0.0 < number) {
            positive = true;
        }
        return positive;
    }

    public static boolean isPositive(int number) {
        boolean positive = false;
        if (0 < number) {
            positive = true;
        }
        return positive;
    }

    public static boolean isPositive(long number) {
        boolean positive = false;
        if (0L < number) {
            positive = true;
        }
        return positive;
    }

    public static boolean isPrevious(Integer number, Integer previousNumber) {
        int previous = number - 1;
        return previous == previousNumber;
    }

    static boolean isPrime(int n) {
        int mod = 1;
        int end = (int)Math.sqrt(n);
        for (int i = 2; i <= end && mod != 0; ++i) {
            mod = n % i;
        }
        return mod != 0;
    }

    public static boolean isPrimeNumber(int number) {
        int a = 1;
        int telos = (int)Math.sqrt(number);
        for (int count = 2; count <= telos && a != 0; ++count) {
            a = number % count;
        }
        return a != 0;
    }

    public static int[] printAllPrimeNumbersTill(int noOfPrimes) {
        int[] primes;
        for (int prime : primes = MathExtensions.getPrimeNumbers(noOfPrimes)) {
            System.out.println(prime + " is a prime number");
        }
        return primes;
    }
}

