/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.object;

import de.alpharogroup.exception.ExceptionExtensions;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public final class CopyObjectExtensions {
    private static final Logger LOG = Logger.getLogger((String)CopyObjectExtensions.class.getName());

    public static final <ORIGINAL, DESTINATION> DESTINATION copy(ORIGINAL original, DESTINATION destination) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        BeanUtils.copyProperties(destination, original);
        return destination;
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copyQuietly(ORIGINAL original, DESTINATION destination) {
        try {
            return CopyObjectExtensions.copy(original, destination);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Error occured by try to copy the original object to destination object.\noriginal object info:" + ExceptionExtensions.toString(original) + "\ndestination object info:" + ExceptionExtensions.toString(destination) + "\n Possible reason: a caller does not have access to the property accessor method"), (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)("Error occured by try to copy the original object to destination object.\noriginal object info:" + ExceptionExtensions.toString(original) + "\ndestination object info:" + ExceptionExtensions.toString(destination) + "\n Possible reason: if the property accessor method throws an exception"), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Error occured by try to copy the original object to destination object.\noriginal object info:" + ExceptionExtensions.toString(original) + "\ndestination object info:" + ExceptionExtensions.toString(destination) + "\n Possible reason: if the destination or original argument is null or if the destination property type is different from the source type and the relevant converter has not been registered."), (Throwable)e);
            return null;
        }
    }

    public static final <DESTINATION, ORIGINAL> boolean isCopyable(ORIGINAL original, DESTINATION destination) {
        return CopyObjectExtensions.copyQuietly(original, destination) != null;
    }

    private CopyObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

