/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.util;

import de.alpharogroup.lang.ClassExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.joda.time.DateTime;

public class ManifestVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Manifest manifest;
    private DateTime lastModified;
    private String version;
    private String title;

    public static ManifestVersion get(Class<?> clazz) {
        String manifestUrl = ClassExtensions.getManifestUrl(clazz);
        try {
            return ManifestVersion.of(manifestUrl != null ? new URL(manifestUrl) : null);
        }
        catch (MalformedURLException ignore) {
            return ManifestVersion.of(null);
        }
    }

    private static ManifestVersion of(URL url) {
        ManifestVersion version = new ManifestVersion();
        if (url != null) {
            URLConnection urlConnection = null;
            try {
                urlConnection = url.openConnection();
                version.setLastModified(new DateTime(urlConnection.getLastModified()));
                version.setManifest(new Manifest(urlConnection.getInputStream()));
                version.setTitle(version.getManifestAttribute(Attributes.Name.IMPLEMENTATION_TITLE));
                version.setVersion(version.getManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION));
            }
            catch (IOException e) {
                throw new RuntimeException("Error while try to load manifest file from " + url, e);
            }
        }
        return version;
    }

    public String getManifestAttribute(Attributes.Name name) {
        Attributes attributes;
        Object value;
        if (this.getManifest() != null && (value = (attributes = this.getManifest().getMainAttributes()).get(name)) != null) {
            return value.toString().trim();
        }
        return "";
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public void setLastModified(DateTime lastModified) {
        this.lastModified = lastModified;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManifestVersion)) {
            return false;
        }
        ManifestVersion other = (ManifestVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Manifest this$manifest = this.getManifest();
        Manifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        DateTime this$lastModified = this.getLastModified();
        DateTime other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !this$lastModified.equals(other$lastModified)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ManifestVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Manifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        DateTime $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : $lastModified.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ManifestVersion(manifest=" + this.getManifest() + ", lastModified=" + this.getLastModified() + ", version=" + this.getVersion() + ", title=" + this.getTitle() + ")";
    }
}

