/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class ConnectionsExtensions {
    private static final Logger logger = Logger.getLogger((String)ConnectionsExtensions.class.getName());
    public static final String MYSQL_DRIVERNAME = "com.mysql.jdbc.Driver";
    public static final String MYSQL_PREFIX_URL = "jdbc:mysql://";
    public static final int MYSQL_PORT = 3306;
    public static final String POSTGRESQL_DRIVERNAME = "org.postgresql.Driver";
    public static final String POSTGRESQL_PREFIX_URL = "jdbc:postgresql://";
    public static final int POSTGRESQL_PORT = 5432;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropPostgreSQLDatabase(String hostname, String databaseName, String dbuser, String dbpasswort) throws SQLException, ClassNotFoundException {
        if (ConnectionsExtensions.existsPostgreSQLDatabase(hostname, databaseName, dbuser, dbpasswort)) {
            Connection connection = null;
            Statement stmt = null;
            try {
                connection = ConnectionsExtensions.getPostgreSQLConnection(hostname, "", dbuser, dbpasswort);
                stmt = connection.createStatement();
                StringBuilder sb = new StringBuilder();
                sb.append("DROP DATABASE ");
                sb.append(databaseName);
                stmt.executeUpdate(sb.toString());
                stmt.close();
                connection.close();
            }
            finally {
                if (stmt != null && !stmt.isClosed()) {
                    stmt.close();
                }
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
        }
    }

    public static void executeSqlScript(BufferedReader bufferedReader, Connection connection) throws IOException, SQLException {
        ConnectionsExtensions.executeSqlScript(bufferedReader, connection, false);
    }

    public static void executeSqlScript(BufferedReader bufferedReader, Connection connection, boolean log) throws IOException, SQLException {
        String s;
        StringBuilder sb = new StringBuilder();
        while ((s = bufferedReader.readLine()) != null) {
            sb.append(s);
        }
        bufferedReader.close();
        String sqlScript = sb.toString();
        ConnectionsExtensions.executeSqlScript(connection, sqlScript, log);
    }

    public static void executeSqlScript(Connection connection, String sqlScript) throws SQLException {
        ConnectionsExtensions.executeSqlScript(connection, sqlScript, false);
    }

    public static void executeSqlScript(Connection connection, String sqlScript, boolean log) throws SQLException {
        String[] inst = sqlScript.split(";");
        Statement st = connection.createStatement();
        if (log) {
            for (String inst1 : inst) {
                if (inst1.trim().equals("")) continue;
                st.executeUpdate(inst1);
                logger.info((Object)(">>" + inst1));
            }
        } else {
            for (String inst1 : inst) {
                if (inst1.trim().equals("")) continue;
                st.executeUpdate(inst1);
            }
        }
        st.close();
    }

    public static boolean existsMySqlDatabase(String hostname, String databaseName, String dbuser, String dbpasswort) throws SQLException, ClassNotFoundException {
        ArrayList<String> existingDatabases = new ArrayList<String>();
        Connection connection = ConnectionsExtensions.getMySQLConnection(hostname, "", dbuser, dbpasswort);
        DatabaseMetaData meta = connection.getMetaData();
        ResultSet rs = meta.getCatalogs();
        while (rs.next()) {
            String existingDatabaseName = rs.getString("TABLE_CAT");
            existingDatabases.add(existingDatabaseName);
        }
        if (existingDatabases.contains(databaseName)) {
            return true;
        }
        rs.close();
        if (connection != null && !connection.isClosed()) {
            connection.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsPostgreSQLDatabase(String hostname, String databaseName, String dbuser, String dbpasswort) throws ClassNotFoundException, SQLException {
        Connection connection = null;
        try {
            connection = ConnectionsExtensions.getPostgreSQLConnection(hostname, databaseName, dbuser, dbpasswort);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        return true;
    }

    public static Connection getMySQLConnection(String hostname, int portNumber, String databaseName, String dbuser, String dbpasswort) throws ClassNotFoundException, SQLException {
        String url = MYSQL_PREFIX_URL + hostname + ":" + portNumber + "/" + databaseName;
        Class.forName(MYSQL_DRIVERNAME);
        return DriverManager.getConnection(url, dbuser, dbpasswort);
    }

    public static Connection getMySQLConnection(String hostname, String databaseName, String dbuser, String dbpasswort) throws ClassNotFoundException, SQLException {
        return ConnectionsExtensions.getMySQLConnection(hostname, 3306, databaseName, dbuser, dbpasswort);
    }

    public static Connection getPostgreSQLConnection(String hostname, String databaseName, String dbuser, String dbpasswort) throws ClassNotFoundException, SQLException {
        return ConnectionsExtensions.getPostgresSQLConnection(hostname, 5432, databaseName, dbuser, dbpasswort);
    }

    public static Connection getPostgresSQLConnection(String hostname, int portNumber, String databaseName, String dbuser, String dbpasswort) throws ClassNotFoundException, SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(POSTGRESQL_PREFIX_URL);
        sb.append(hostname);
        sb.append(":");
        sb.append(portNumber);
        sb.append("/");
        sb.append(databaseName);
        Class.forName(POSTGRESQL_DRIVERNAME);
        return DriverManager.getConnection(sb.toString().trim(), dbuser, dbpasswort);
    }

    public static void newMySqlDatabase(String hostname, String databaseName, String dbuser, String dbpasswort) throws SQLException, ClassNotFoundException {
        ConnectionsExtensions.newMySqlDatabase(hostname, databaseName, dbuser, dbpasswort, "utf8", "utf8_general_ci");
    }

    public static void newMySqlDatabase(String hostname, String databaseName, String dbuser, String dbpasswort, String characterSet, String collate) throws SQLException, ClassNotFoundException {
        if (!ConnectionsExtensions.existsMySqlDatabase(hostname, databaseName, dbuser, dbpasswort)) {
            Connection connection = ConnectionsExtensions.getMySQLConnection(hostname, "", dbuser, dbpasswort);
            Statement stmt = connection.createStatement();
            String sql = "CREATE DATABASE " + databaseName + " DEFAULT CHARACTER SET " + characterSet + " COLLATE " + collate;
            stmt.executeUpdate(sql);
            stmt.close();
            connection.close();
        }
    }

    public static void newPostgreSQLDatabase(String hostname, String databaseName, String dbuser, String dbpasswort, String characterSet, String collate) throws SQLException, ClassNotFoundException {
        if (!ConnectionsExtensions.existsPostgreSQLDatabase(hostname, databaseName, dbuser, dbpasswort)) {
            Connection connection = ConnectionsExtensions.getPostgreSQLConnection(hostname, "", dbuser, dbpasswort);
            Statement stmt = connection.createStatement();
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE DATABASE ");
            sb.append(databaseName);
            if (characterSet != null && !characterSet.isEmpty()) {
                sb.append(" DEFAULT CHARACTER SET ");
                sb.append(characterSet);
                if (collate != null && !collate.isEmpty()) {
                    sb.append(" COLLATE ");
                    sb.append(collate);
                }
            }
            stmt.executeUpdate(sb.toString());
            stmt.close();
            connection.close();
        }
    }

    private ConnectionsExtensions() {
    }
}

