/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.namefilter;

import java.io.File;
import java.io.FilenameFilter;

public class SimpleFilenameFilter
implements FilenameFilter {
    private String filesuffix;
    private boolean acceptDir;

    public SimpleFilenameFilter(String filesuffix, boolean acceptDir) {
        if (null == filesuffix || filesuffix.equals("")) {
            throw new IllegalArgumentException("Argument filesuffix cant be null or empty. Please set the argument filesuffix.");
        }
        this.filesuffix = filesuffix.toLowerCase();
        this.acceptDir = acceptDir;
    }

    @Override
    public boolean accept(File dir, String name) {
        File currentFile = new File(dir, name);
        if (this.acceptDir && currentFile.isDirectory()) {
            return true;
        }
        return name.toLowerCase().endsWith(this.filesuffix);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[SimpleFilenameFilter:");
        buffer.append(" filesuffix: ");
        buffer.append(this.filesuffix);
        buffer.append(" acceptDir: ");
        buffer.append(this.acceptDir);
        buffer.append("]");
        return buffer.toString();
    }
}

