/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.string;

import de.alpharogroup.check.Check;
import de.alpharogroup.string.MalformedUnicodeException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class StringExtensions {
    private static final char[] HEXADECIMAL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String addDoubleQuotationMarks(String s) {
        return "\"" + s + "\"";
    }

    public static final String addSingleQuotationMarks(String s) {
        return "'" + s + "'";
    }

    public static final String firstCharacterToLowerCase(String fieldName) {
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toLowerCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static final String firstCharacterToUpperCase(String fieldName) {
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toUpperCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static final boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean isNumber(String testString) {
        if (null == testString) {
            return false;
        }
        for (int i = 0; i < testString.length(); ++i) {
            if (Character.isDigit(testString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String lastCharacter(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        return str.substring(str.length() - 1);
    }

    public static final String removeQuotationMarks(String s) {
        return s.substring(1, s.length() - 1);
    }

    public static final String replaceLast(String original, String findString, String replacement) {
        int index = original.lastIndexOf(findString);
        if (index == -1) {
            return original;
        }
        StringBuffer originalFiltered = new StringBuffer();
        originalFiltered.append(original.substring(0, index));
        originalFiltered.append(replacement);
        originalFiltered.append(original.substring(index + findString.length()));
        String result = originalFiltered.toString().trim();
        return result;
    }

    private static char toHex(int i) {
        return HEXADECIMAL_DIGITS[i & 0xF];
    }

    public static String toUnicode(String toUnicode, boolean toLowerCase) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toUnicode.length(); ++i) {
            String hex = Integer.toHexString(toUnicode.codePointAt(i));
            hex = toLowerCase ? hex.toLowerCase() : hex.toUpperCase();
            String hexWithZeros = "0000" + hex;
            String hexCodeWithLeadingZeros = hexWithZeros.substring(hexWithZeros.length() - 4);
            sb.append("\\u" + hexCodeWithLeadingZeros);
        }
        return sb.toString();
    }

    public static String toUnicodeChars(String s, boolean toLowerCase) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int length = s.length();
        int sbLength = length * 2;
        StringBuilder sb = new StringBuilder(sbLength);
        block8: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    sb.append('\\');
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block8;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block8;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block8;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block8;
                }
                case ' ': {
                    if (i == 0) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(StringExtensions.toHex(c >> 12 & 0xF));
                        sb.append(StringExtensions.toHex(c >> 8 & 0xF));
                        sb.append(StringExtensions.toHex(c >> 4 & 0xF));
                        sb.append(StringExtensions.toHex(c & 0xF));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        String returnString = sb.toString();
        if (toLowerCase) {
            return returnString.toLowerCase();
        }
        return returnString;
    }

    public static final byte[] convertToBytearray(char[] source) {
        byte[] result = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = (byte)source[i];
        }
        return result;
    }

    public static char[] convertToCharArray(byte[] source) {
        if (source == null) {
            return null;
        }
        char[] result = new char[source.length];
        for (int i = 0; i < source.length; ++i) {
            result[i] = (char)source[i];
        }
        return result;
    }

    public static Character convertUnicodeStringToCharacter(String theUnicodeString) {
        int length = theUnicodeString.length();
        StringBuilder sb = new StringBuilder(length);
        int outerCount = 0;
        while (outerCount < length) {
            int current;
            if ((current = theUnicodeString.charAt(outerCount++)) == 92) {
                if ((current = theUnicodeString.charAt(outerCount++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        current = theUnicodeString.charAt(outerCount++);
                        switch (current) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + current - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + current - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + current - 65;
                                continue block6;
                            }
                            default: {
                                throw new MalformedUnicodeException("Given String object :::" + theUnicodeString + "::: is not a well formed unicode String object.\nFormat for a well formed unicode String object:'\\uxxxx'.");
                            }
                        }
                    }
                    sb.append((char)value);
                    continue;
                }
                if (current == 116) {
                    current = 9;
                } else if (current == 114) {
                    current = 13;
                } else if (current == 110) {
                    current = 10;
                } else if (current == 102) {
                    current = 12;
                }
                sb.append((char)current);
                continue;
            }
            sb.append((char)current);
        }
        String result = sb.toString();
        char c = result.charAt(0);
        return Character.valueOf(c);
    }

    public static byte[] decodeHex(char[] data) throws DecoderException {
        return Hex.decodeHex((char[])data);
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex((byte[])data, (boolean)true);
    }

    public static final String getAttributName(String name) {
        int indexStart = name.indexOf("[");
        String returnName = name.substring(0, indexStart);
        return returnName;
    }

    public static final String getIndex(String name) {
        int firstIndexStart = name.indexOf("[");
        int firstIndexEnd = name.indexOf("]");
        String index = name.substring(firstIndexStart + 1, firstIndexEnd);
        return index;
    }

    public static final String getItemNumber(String name) {
        int lastIndexStart = name.lastIndexOf("[");
        int lastIndexEnd = name.lastIndexOf("]");
        String itemNumber = name.substring(lastIndexStart + 1, lastIndexEnd);
        return itemNumber;
    }

    public static final String getStringAfterUnderscore(String element) {
        String returnString = null;
        int i = element.indexOf("_");
        returnString = element.substring(i + 1, element.length());
        return returnString;
    }

    public static final String getStringBeforeUnderscore(String element) {
        Check.get().notNull((Object)element, "string").notEmpty((CharSequence)element, "string");
        return element.substring(0, element.indexOf("_"));
    }

    public static String getValue(Map<String, String> data, String key, String defaultValue) {
        String value = data.get(key);
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    public static final String readLine(String stringWithCarriageReturns) {
        String returnString = "";
        int index = 0;
        index = stringWithCarriageReturns.indexOf(System.getProperty("line.separator"));
        if (index < 0) {
            index = stringWithCarriageReturns.indexOf("\n");
        }
        if (index < 0) {
            index = stringWithCarriageReturns.indexOf("\r");
        }
        returnString = stringWithCarriageReturns.substring(0, index);
        return returnString;
    }

    public static String[] removeEmptyString(String[] words) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < words.length; ++i) {
            if (words[i].isEmpty()) continue;
            al.add(words[i]);
        }
        return al.toArray(new String[al.size()]);
    }

    public static String removeNewlineCharacters(String subject) {
        if (subject.contains("\n")) {
            subject = subject.replace("\n", "");
        }
        if (subject.contains("\r")) {
            subject = subject.replace("\r", "");
        }
        return subject;
    }

    public static final String replaceAll(String original, String findString, String replaceWith) {
        StringBuffer originalFiltered = new StringBuffer();
        int next = 0;
        int count = 0;
        int length = findString.length();
        while (count > -1) {
            count = original.indexOf(findString, next);
            if (count <= -1) continue;
            originalFiltered.append(original.substring(next, count));
            originalFiltered.append(replaceWith);
            next = count + length;
        }
        originalFiltered.append(original.substring(next, original.length()));
        return originalFiltered.toString();
    }

    public static final String replaceAll(String original, String[] findString, String replaceWith) {
        String result = original;
        for (String element : findString) {
            result = StringExtensions.replaceAll(result, element, replaceWith);
        }
        return result;
    }

    public static String replaceEach(String input, String searchRegexPattern, String replace) {
        Pattern pattern = Pattern.compile(searchRegexPattern);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replace);
    }
}

