/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.file.FileExtension;
import de.alpharogroup.file.FilenameExtensions;
import de.alpharogroup.file.filter.ClassFileFilter;
import de.alpharogroup.lang.ClassType;
import de.alpharogroup.lang.PackageExtensions;
import de.alpharogroup.string.StringExtensions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class ClassExtensions {
    protected static final Logger LOGGER = Logger.getLogger(ClassExtensions.class);

    public static boolean equalsByClassName(Class<?> oneClass, Class<?> otherClass) {
        String oneNormalizedClassName = ClassExtensions.normalizeQualifiedClassName(oneClass.getName());
        String otherNormalizedClassName = ClassExtensions.normalizeQualifiedClassName(otherClass.getName());
        return otherNormalizedClassName.equals(oneNormalizedClassName);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> clazz;
        block2: {
            clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (Throwable throwable) {
                clazz = Class.forName(className, true, ClassExtensions.getClassLoader());
                if (clazz != null) break block2;
                throw throwable;
            }
        }
        return clazz;
    }

    public static Class<?> getBaseClass(Class<?> childClass) {
        Class<?> superClass;
        if (childClass == null) {
            return childClass;
        }
        for (superClass = childClass.getSuperclass(); superClass != null && !superClass.getSuperclass().equals(Object.class); superClass = superClass.getSuperclass()) {
        }
        if (superClass == null) {
            return childClass;
        }
        return superClass;
    }

    public static ClassLoader getClassLoader() {
        return ClassExtensions.getClassLoader(null);
    }

    public static ClassLoader getClassLoader(Object obj) {
        ClassLoader classLoader = null;
        if (null != obj) {
            classLoader = ClassExtensions.isDerivate(Thread.currentThread().getContextClassLoader(), obj.getClass().getClassLoader()) ? obj.getClass().getClassLoader() : Thread.currentThread().getContextClassLoader();
            if (ClassExtensions.isDerivate(classLoader, ClassLoader.getSystemClassLoader())) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
        } else {
            classLoader = ClassExtensions.isDerivate(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()) ? ClassLoader.getSystemClassLoader() : Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static String getClassnameWithSuffix(Class<?> clazz) {
        String className = clazz.getName();
        className = className.substring(className.lastIndexOf(46) + 1) + FileExtension.CLASS.getExtension();
        return className;
    }

    public static String getClassnameWithSuffix(Object obj) {
        return ClassExtensions.getClassnameWithSuffix(obj.getClass());
    }

    public static ClassType getClassType(Class<?> clazz) {
        if (clazz.isArray()) {
            return ClassType.ARRAY;
        }
        if (ClassExtensions.isCollection(clazz)) {
            return ClassType.COLLECTION;
        }
        if (ClassExtensions.isMap(clazz)) {
            return ClassType.MAP;
        }
        if (clazz.isLocalClass()) {
            return ClassType.LOCAL;
        }
        if (clazz.isMemberClass()) {
            return ClassType.MEMBER;
        }
        if (clazz.isPrimitive()) {
            return ClassType.PRIMITIVE;
        }
        if (clazz.isAnnotation()) {
            return ClassType.ANNOTATION;
        }
        if (clazz.isEnum()) {
            return ClassType.ENUM;
        }
        if (clazz.isInterface()) {
            return ClassType.INTERFACE;
        }
        if (clazz.isSynthetic()) {
            return ClassType.SYNTHETIC;
        }
        if (clazz.isAnonymousClass()) {
            return ClassType.ANONYMOUS;
        }
        return ClassType.DEFAULT;
    }

    public static List<File> getDirectoriesFromResources(String path, boolean isPackage) throws IOException {
        if (isPackage) {
            path = path.replace('.', '/');
        }
        List<URL> resources = ClassExtensions.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        for (URL resource : resources) {
            dirs.add(new File(URLDecoder.decode(resource.getFile(), "UTF-8")));
        }
        return dirs;
    }

    public static String getManifestUrl(Class<?> clazz) {
        String classUrlString;
        String manifestUrl = null;
        String path = ClassExtensions.getPath(clazz);
        URL classUrl = ClassExtensions.getResource(path);
        if (classUrl != null && ((classUrlString = classUrl.toString()).startsWith("jar:") && classUrlString.indexOf(path) > 0 || classUrlString.startsWith("war:") && classUrlString.indexOf(path) > 0 || classUrlString.startsWith("ear:") && classUrlString.indexOf(path) > 0 || classUrlString.startsWith("file:") && classUrlString.indexOf(path) > 0)) {
            manifestUrl = classUrlString.replace(path, "/META-INF/MANIFEST.MF");
        }
        return manifestUrl;
    }

    public static String getJarPath(Class<?> clazz) {
        String classUrlString;
        String jarPath = null;
        String jarPathPrefix = "jar:";
        String jarPathFilePrefix = "jar:file:";
        String path = ClassExtensions.getPath(clazz);
        URL classUrl = ClassExtensions.getResource(path);
        if (classUrl != null && (classUrlString = classUrl.toString()).startsWith("jar:") && classUrlString.indexOf(path) > 0 && (jarPath = classUrlString.replace("!" + path, "")).startsWith("jar:file:")) {
            int beginIndex = "jar:file:".length();
            jarPath = jarPath.substring(beginIndex, jarPath.length());
        }
        return jarPath;
    }

    public static String getName(Class<?> clazz) {
        return ClassExtensions.getName(clazz, false);
    }

    public static String getName(Class<?> clazz, boolean simple) {
        String name = null;
        if (clazz != null) {
            while (clazz.isAnonymousClass()) {
                clazz = clazz.getSuperclass();
            }
            name = simple ? clazz.getSimpleName() : clazz.getName();
        }
        return name;
    }

    public static String getPath(Class<?> clazz) {
        String packagePath = PackageExtensions.getPackagePath(clazz);
        String className = ClassExtensions.getSimpleName(clazz);
        StringBuilder sb = new StringBuilder().append("/").append(packagePath).append(className).append(FileExtension.CLASS.getExtension());
        String path = sb.toString();
        return path;
    }

    public static String getPathFromObject(Object obj) {
        if (obj == null) {
            return null;
        }
        String pathFromObject = obj.getClass().getResource(ClassExtensions.getClassnameWithSuffix(obj)).getPath();
        return pathFromObject;
    }

    public static URL getResource(Class<?> clazz, String path) {
        URL url = clazz.getResource(path);
        if (url == null) {
            url = ClassExtensions.getClassLoader().getResource(path);
        }
        return url;
    }

    public static URL getResource(Class<?> clazz) {
        String path = ClassExtensions.getPath(clazz);
        URL url = clazz.getResource(path);
        if (url == null) {
            url = ClassExtensions.getClassLoader().getResource(path);
        }
        return url;
    }

    public static URL getResource(String name) {
        String path = name;
        if (name.startsWith("/")) {
            path = name.substring(1, name.length());
        }
        URL url = ClassExtensions.getClassLoader().getResource(path);
        return url;
    }

    public static <T> URL getResource(String name, T obj) {
        Class<?> clazz = obj.getClass();
        URL url = clazz.getResource(name);
        if (url == null) {
            url = ClassExtensions.getResource(clazz, name);
        }
        return url;
    }

    public static File getResourceAsFile(String name) throws URISyntaxException {
        File file = null;
        URL url = ClassExtensions.getResource(name);
        if (null == url) {
            url = ClassExtensions.getClassLoader().getResource(name);
            if (null != url) {
                file = new File(url.toURI());
            }
        } else {
            file = new File(url.toURI());
        }
        return file;
    }

    public static File getResourceAsFile(String name, Object obj) throws URISyntaxException {
        File file = null;
        URL url = ClassExtensions.getResource(name, obj);
        if (null == url) {
            url = ClassExtensions.getClassLoader(obj).getResource(name);
            if (null != url) {
                file = new File(url.toURI());
            }
        } else {
            file = new File(url.toURI());
        }
        return file;
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String uri) {
        InputStream is = clazz.getResourceAsStream(uri);
        if (null == is) {
            is = ClassExtensions.getClassLoader().getResourceAsStream(uri);
        }
        return is;
    }

    public static InputStream getResourceAsStream(String name) {
        ClassLoader loader = ClassExtensions.getClassLoader();
        InputStream inputStream = loader.getResourceAsStream(name);
        return inputStream;
    }

    public static InputStream getResourceAsStream(String name, Object obj) {
        InputStream inputStream = obj.getClass().getResourceAsStream(name);
        if (null == inputStream) {
            ClassLoader loader = ClassExtensions.getClassLoader(obj);
            inputStream = loader.getResourceAsStream(name);
        }
        return inputStream;
    }

    public static List<URL> getResources(String path) throws IOException {
        ClassLoader classLoader = ClassExtensions.getClassLoader();
        ArrayList<URL> list = Collections.list(classLoader.getResources(path));
        return list;
    }

    public static String getSimpleName(Class<?> clazz) {
        return ClassExtensions.getName(clazz, true);
    }

    public static URL getURL(Class<?> clazz) {
        return ClassExtensions.getResource(ClassExtensions.getPath(clazz));
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isDerivate(ClassLoader source, ClassLoader compare) {
        if (source == compare) {
            return true;
        }
        if (compare == null) {
            return false;
        }
        if (source == null) {
            return true;
        }
        while (null != compare) {
            if (source != (compare = compare.getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMap(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public static String normalizeQualifiedClassName(String qualifiedClassname) {
        return StringExtensions.replaceAll(ClassExtensions.normalizeSimpleClassName(qualifiedClassname), "/", ".");
    }

    public static String normalizeSimpleClassName(String className) {
        int lastIndexOf$;
        String result = className;
        if (className.endsWith(FileExtension.CLASS.getExtension())) {
            result = StringExtensions.replaceLast(className, FileExtension.CLASS.getExtension(), "");
        }
        if ((lastIndexOf$ = result.lastIndexOf("$")) != -1) {
            String prefix = result.substring(0, lastIndexOf$);
            String compilerClassName = result.substring(lastIndexOf$ + 1, result.length());
            if (StringUtils.isNumeric((String)compilerClassName)) {
                return prefix;
            }
        }
        return result;
    }

    public static Set<Class<?>> scanClassesFromPackage(File directory, String packagePath) throws ClassNotFoundException {
        return ClassExtensions.scanClassesFromPackage(directory, packagePath, false);
    }

    public static Set<Class<?>> scanClassesFromPackage(File directory, String packagePath, boolean recursive) throws ClassNotFoundException {
        File[] files;
        LinkedHashSet foundClasses = new LinkedHashSet();
        if (!directory.exists()) {
            return foundClasses;
        }
        ClassFileFilter includeFileFilter = new ClassFileFilter();
        for (File file : files = directory.listFiles(includeFileFilter)) {
            String qualifiedClassname = null;
            if (file.isDirectory() && recursive) {
                qualifiedClassname = packagePath + "." + file.getName();
                foundClasses.addAll(ClassExtensions.scanClassesFromPackage(file, qualifiedClassname, recursive));
                continue;
            }
            if (file.isDirectory()) continue;
            String filename = FilenameExtensions.getFilenameWithoutExtension(file);
            qualifiedClassname = packagePath + '.' + filename;
            foundClasses.add(ClassExtensions.forName(qualifiedClassname));
        }
        return foundClasses;
    }

    public static Set<Class<?>> scanClassNames(String packageName) throws IOException, ClassNotFoundException {
        return ClassExtensions.scanClassNames(packageName, false);
    }

    public static Set<Class<?>> scanClassNames(String packageName, boolean recursive) throws IOException, ClassNotFoundException {
        LinkedHashSet foundClasses = new LinkedHashSet();
        Set<String> qualifiedClassnames = PackageExtensions.scanClassNames(packageName, recursive, true);
        for (String qualifiedClassname : qualifiedClassnames) {
            foundClasses.add(ClassExtensions.forName(qualifiedClassname));
        }
        return foundClasses;
    }
}

