/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.namefilter;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;

public class MultiplyExtensionsFilenameFilter
implements FilenameFilter {
    private Collection<String> fileExtensions;
    private boolean acceptDir;

    public MultiplyExtensionsFilenameFilter(Collection<String> fileExtensions) {
        if (null == fileExtensions || fileExtensions.isEmpty()) {
            throw new IllegalArgumentException("Argument fileExtensions cant be null or empty. Please set the argument fileExtensions appropriate.");
        }
        this.fileExtensions = new ArrayList<String>(fileExtensions.size());
        for (String extension : fileExtensions) {
            this.fileExtensions.add(extension.toLowerCase());
        }
    }

    public MultiplyExtensionsFilenameFilter(Collection<String> fileExtensions, boolean acceptDir) {
        if (null == fileExtensions || fileExtensions.isEmpty()) {
            throw new IllegalArgumentException("Argument fileExtensions cant be null or empty. Please set the argument fileExtensions appropriate.");
        }
        this.fileExtensions = new ArrayList<String>(fileExtensions.size());
        this.acceptDir = acceptDir;
        for (String extension : fileExtensions) {
            this.fileExtensions.add(extension.toLowerCase());
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        File currentFile = new File(dir, name);
        if (this.acceptDir && currentFile.isDirectory()) {
            return true;
        }
        for (String extension : this.fileExtensions) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[MultiplyExtensionsFilenameFilter:");
        buffer.append(" fileExtensions: ");
        buffer.append(this.fileExtensions);
        buffer.append(" acceptDir: ");
        buffer.append(this.acceptDir);
        buffer.append("]");
        return buffer.toString();
    }
}

