/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.regex;

import de.alpharogroup.string.StringExtensions;

public class RegExExtensions {
    public static final String WILDCARD_ASTERISK = "*";
    public static final String WILDCARD_QUESTION_MARK = "?";
    public static final String VALID_CHARS_IN_FILENAME = "[a-zA-Z0-9._-]";
    public static final String WILDCARD_ONECHAR_RE = "[a-zA-Z0-9._-]{1}";
    public static final String WILDCARD_MANYCHARS_RE = ".*";
    public static final String VALID_EMAIL = "([\\w\\-\\.\\+_]+@[\\w\\-\\._]{2,}\\.+[\\w]{2,4})?";
    public static final String VALID_PHONE = "^[a-zA-Z .,;:/\\-]*[ ]*[(]{0,1}[ ]*[+]{0,1}[ ]*[0-9]{0,2}[ ]*[)]{0,1}[ ]*[0-9]*[ ]*[/\\-]{0,1}[ ]*[ ]*[0-9]*[ ]*[a-zA-Z .,;:\\/-]*$";

    public static String replaceWildcardsWithRE(String queryString) {
        String stern = StringExtensions.replaceAll(queryString, WILDCARD_ASTERISK, WILDCARD_MANYCHARS_RE);
        String regexp = StringExtensions.replaceAll(stern, WILDCARD_QUESTION_MARK, WILDCARD_ONECHAR_RE);
        return regexp;
    }

    public static String wildcardCriterionSQL(String query) {
        String newQuery = query.replace('*', '%').replace('?', '_');
        return newQuery;
    }
}

