/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.object;

import de.alpharogroup.check.Check;
import de.alpharogroup.exception.ExceptionExtensions;
import de.alpharogroup.io.ChangedAttributeResult;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.lang.object.CompareObjectExtensions;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public final class MergeObjectExtensions {
    private static final Logger LOG = Logger.getLogger((String)MergeObjectExtensions.class.getName());

    public static final <MERGE_IN, WITH> void merge(MERGE_IN mergeInObject, WITH withObject) throws InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        Check.get().notNull(mergeInObject, "mergeInObject").notNull(withObject, "withObject");
        Class<?> toClass = mergeInObject.getClass();
        for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(toClass)) {
            MergeObjectExtensions.mergeProperty(mergeInObject, withObject, descriptor);
        }
    }

    public static final <MERGE_IN, WITH> void mergeQuietly(MERGE_IN mergeInObject, WITH withObject) {
        try {
            MergeObjectExtensions.merge(mergeInObject, withObject);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)("Error occured by try to copy the original object to destination object.\noriginal object info:" + ExceptionExtensions.toString(withObject) + "\ndestination object info:" + ExceptionExtensions.toString(mergeInObject) + "\n Possible reason: if the property accessor method throws an exception"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Error occured by try to merge the original object to destination object.\noriginal object info:" + ExceptionExtensions.toString(withObject) + "\ndestination object info:" + ExceptionExtensions.toString(mergeInObject) + "\n Possible reason: a caller does not have access to the property accessor method"), (Throwable)e);
        }
    }

    public static final <MERGE_IN, WITH> void mergeProperty(MERGE_IN mergeInObject, WITH withObject, PropertyDescriptor propertyDescriptor) throws IllegalAccessException, InvocationTargetException {
        Method getter;
        Object value;
        if (PropertyUtils.isReadable(mergeInObject, (String)propertyDescriptor.getName()) && PropertyUtils.isWriteable(mergeInObject, (String)propertyDescriptor.getName()) && !ObjectExtensions.isDefaultValue(value = (getter = propertyDescriptor.getReadMethod()).invoke(withObject, new Object[0]))) {
            Method setter = propertyDescriptor.getWriteMethod();
            setter.invoke(mergeInObject, value);
        }
    }

    public static List<ChangedAttributeResult> getChangedData(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        ArrayList<ChangedAttributeResult> changedData = new ArrayList<ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            if (CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            changedData.add(new ChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    public static Map<Object, ChangedAttributeResult> getChangedDataMap(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        HashMap<Object, ChangedAttributeResult> changedData = new HashMap<Object, ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            if (CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            changedData.put(key, new ChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    private MergeObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

