/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.io;

import de.alpharogroup.io.SerializedChangedAttributeResult;
import de.alpharogroup.io.StreamExtensions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;

public final class SerializedObjectExtensions {
    protected static final Logger LOGGER = Logger.getLogger(SerializedObjectExtensions.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T copySerializedObject(T orig) throws IOException, ClassNotFoundException {
        Serializable object = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(orig);
            objectOutputStream.flush();
            objectOutputStream.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            object = (Serializable)ois.readObject();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeOutputStream(byteArrayOutputStream);
            StreamExtensions.closeOutputStream(objectOutputStream);
            throw throwable;
        }
        StreamExtensions.closeOutputStream(byteArrayOutputStream);
        StreamExtensions.closeOutputStream(objectOutputStream);
        return (T)object;
    }

    public static List<SerializedChangedAttributeResult> getChangedData(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        ArrayList<SerializedChangedAttributeResult> changedData = new ArrayList<SerializedChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            BeanComparator comparator = new BeanComparator(key.toString());
            if (comparator.compare(sourceOjbect, objectToCompare) == 0) continue;
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            changedData.add(new SerializedChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    public static Map<Object, SerializedChangedAttributeResult> getChangedDataMap(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        HashMap<Object, SerializedChangedAttributeResult> changedData = new HashMap<Object, SerializedChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            BeanComparator comparator = new BeanComparator(key.toString());
            if (comparator.compare(sourceOjbect, objectToCompare) == 0) continue;
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            changedData.put(key, new SerializedChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readSerializedObjectFromFile(File file) throws IOException, ClassNotFoundException {
        Object object = null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(file);
            in = new ObjectInputStream(fis);
            object = in.readObject();
            in.close();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeInputStream(in);
            StreamExtensions.closeInputStream(fis);
            throw throwable;
        }
        StreamExtensions.closeInputStream(in);
        StreamExtensions.closeInputStream(fis);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] toByteArray(T object) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byteArrayOutputStream.reset();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeOutputStream(byteArrayOutputStream);
            StreamExtensions.closeOutputStream(objectOutputStream);
            throw throwable;
        }
        StreamExtensions.closeOutputStream(byteArrayOutputStream);
        StreamExtensions.closeOutputStream(objectOutputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(byte[] byteArray) throws IOException, ClassNotFoundException {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byteArray);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeInputStream(byteArrayInputStream);
            StreamExtensions.closeInputStream(objectInputStream);
            throw throwable;
        }
        StreamExtensions.closeInputStream(byteArrayInputStream);
        StreamExtensions.closeInputStream(objectInputStream);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeSerializedObjectToFile(Object obj, File file) throws IOException {
        boolean written = true;
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeOutputStream(oos);
            StreamExtensions.closeOutputStream(fos);
            throw throwable;
        }
        StreamExtensions.closeOutputStream(oos);
        StreamExtensions.closeOutputStream(fos);
        return true;
    }

    private SerializedObjectExtensions() {
    }
}

