/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang.object;

import de.alpharogroup.check.Check;
import de.alpharogroup.io.ChangedAttributeResult;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.lang.object.CompareObjectExtensions;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public final class MergeObjectExtensions {
    public static final <TO, WITH> void merge(TO toObject, WITH withObject) throws InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        Check.get().notNull(toObject, "toObject").notNull(withObject, "toObject");
        Class<?> toClass = toObject.getClass();
        for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(toClass)) {
            MergeObjectExtensions.mergeProperty(toObject, withObject, descriptor);
        }
    }

    public static final <TO, WITH> void mergeProperty(TO toObject, WITH withObject, PropertyDescriptor propertyDescriptor) throws IllegalAccessException, InvocationTargetException {
        Method getter;
        Object value;
        if (PropertyUtils.isReadable(toObject, (String)propertyDescriptor.getName()) && PropertyUtils.isWriteable(toObject, (String)propertyDescriptor.getName()) && !ObjectExtensions.isDefaultValue(value = (getter = propertyDescriptor.getReadMethod()).invoke(withObject, new Object[0]))) {
            Method setter = propertyDescriptor.getWriteMethod();
            setter.invoke(toObject, value);
        }
    }

    public static List<ChangedAttributeResult> getChangedData(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        ArrayList<ChangedAttributeResult> changedData = new ArrayList<ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            if (CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            changedData.add(new ChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    public static Map<Object, ChangedAttributeResult> getChangedDataMap(Object sourceOjbect, Object objectToCompare) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (sourceOjbect == null || objectToCompare == null || !sourceOjbect.getClass().equals(objectToCompare.getClass())) {
            throw new IllegalArgumentException("Object should not be null and be the same type.");
        }
        Map beanDescription = BeanUtils.describe((Object)sourceOjbect);
        beanDescription.remove("class");
        Map clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        clonedBeanDescription.remove("class");
        HashMap<Object, ChangedAttributeResult> changedData = new HashMap<Object, ChangedAttributeResult>();
        for (Object key : beanDescription.keySet()) {
            Object sourceAttribute = beanDescription.get(key);
            Object changedAttribute = clonedBeanDescription.get(key);
            if (CompareObjectExtensions.compareTo(sourceOjbect, objectToCompare, key.toString()) == 0) continue;
            changedData.put(key, new ChangedAttributeResult(key, sourceAttribute, changedAttribute));
        }
        return changedData;
    }

    private MergeObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

