/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.i18n.dropdownchoice.panels;

import de.alpharogroup.wicket.components.i18n.dropdownchoice.LocalisedDropDownChoice;
import de.alpharogroup.wicket.model.dropdownchoices.TwoDropDownChoicesModel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketeer.modelfactory.ModelFactory;

public abstract class TwoDropDownChoicesPanel<T>
extends GenericPanel<TwoDropDownChoicesModel<T>> {
    private static final long serialVersionUID = 1L;
    public static final String ROOT_CHOICE_ID = "rootChoice";
    public static final String CHILD_CHOICE_ID = "childChoice";
    private DropDownChoice<T> rootChoice;
    private DropDownChoice<T> childChoice;

    public TwoDropDownChoicesPanel(String id, TwoDropDownChoicesModel<T> stringTwoDropDownChoicesModel, IChoiceRenderer<T> rootRenderer, IChoiceRenderer<T> childRenderer) {
        super(id, (IModel)Model.of(stringTwoDropDownChoicesModel));
        IModel selectedRootOptionModel = null;
        ((TwoDropDownChoicesModel)this.getModelObject()).getRootChoices();
        selectedRootOptionModel = ModelFactory.model(((TwoDropDownChoicesModel)ModelFactory.from((IModel)this.getModel())).getSelectedRootOption());
        this.rootChoice = this.newRootChoice(ROOT_CHOICE_ID, selectedRootOptionModel, ((TwoDropDownChoicesModel)this.getModelObject()).getRootChoices(), rootRenderer);
        IModel selectedChildOptionModel = null;
        selectedChildOptionModel = ModelFactory.model(((TwoDropDownChoicesModel)ModelFactory.from((IModel)this.getModel())).getSelectedChildOption());
        this.childChoice = this.newChildChoice(CHILD_CHOICE_ID, selectedChildOptionModel, ((TwoDropDownChoicesModel)this.getModelObject()).getChildChoices(), childRenderer);
        this.add(new Component[]{this.rootChoice});
        this.add(new Component[]{this.childChoice});
    }

    protected void onInitialize() {
        super.onInitialize();
    }

    protected DropDownChoice<T> newRootChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        LocalisedDropDownChoice rc = new LocalisedDropDownChoice(id, model, choices, renderer);
        rc.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{TwoDropDownChoicesPanel.this.childChoice});
            }
        }});
        return rc;
    }

    protected DropDownChoice<T> newChildChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        LocalisedDropDownChoice cc = new LocalisedDropDownChoice(id, model, choices, renderer);
        cc.setOutputMarkupId(true);
        return cc;
    }

    public DropDownChoice<T> getRootChoice() {
        return this.rootChoice;
    }

    public DropDownChoice<T> getChildChoice() {
        return this.childChoice;
    }
}

