/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.dialogs.ajax.modal;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public abstract class BaseModalPanel<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    private Form<T> form;
    private TextArea<String> note;
    private AjaxButton cancel;
    private AjaxButton ok;

    public BaseModalPanel(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form", model);
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.note = this.newTextArea("messageContent", model);
        componentArray2[0] = this.note;
        this.form.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.cancel = this.newCancelButton("cancelButton");
        componentArray3[0] = this.cancel;
        this.form.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.ok = this.newOkButton("okButton");
        componentArray4[0] = this.ok;
        this.form.add(componentArray4);
    }

    protected AjaxButton newCancelButton(String id) {
        AjaxButton close = new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{BaseModalPanel.this.note});
                BaseModalPanel.this.onCancel(target);
            }

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{BaseModalPanel.this.note});
                BaseModalPanel.this.onCancel(target);
            }
        };
        return close;
    }

    protected Form<T> newForm(String id, IModel<T> model) {
        return ComponentFactory.newForm((String)id, model);
    }

    protected AjaxButton newOkButton(String id) {
        AjaxButton ok = new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                Object obj = BaseModalPanel.this.getModelObject();
                BaseModalPanel.this.onSelect(target, obj);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                Object obj = BaseModalPanel.this.getModelObject();
                BaseModalPanel.this.onSelect(target, obj);
            }
        };
        return ok;
    }

    protected TextArea<String> newTextArea(String id, IModel<T> model) {
        return ComponentFactory.newTextArea((String)id, (IModel)new PropertyModel(model, "messageContent"));
    }

    protected abstract void onCancel(AjaxRequestTarget var1);

    protected abstract void onSelect(AjaxRequestTarget var1, T var2);

    public AjaxButton getCancel() {
        return this.cancel;
    }

    public AjaxButton getOk() {
        return this.ok;
    }
}

