/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.dialogs.ajax.modal;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;

public abstract class ModalDialogFragmentPanel<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    public static final String WICKET_WINDOW_UNLOAD_CONFIRMATION_FALSE_JS = "Wicket.Window.unloadConfirmation = false;";
    private ModalWindow modalWindow;
    private Fragment modalFragment;
    private MarkupContainer openModalLink;

    public ModalDialogFragmentPanel(String id, IModel<T> model) {
        super(id, model);
    }

    protected abstract Component newFragmentContent(String var1, IModel<T> var2);

    protected Fragment newModalFragment(String id, String markupId, MarkupContainer markupProvider, IModel<T> model) {
        Fragment fragment = ComponentFactory.newFragment((String)id, (String)markupId, (MarkupContainer)markupProvider, model);
        return fragment;
    }

    protected ModalWindow newModalWindow(String id, IModel<T> model) {
        ModalWindow modal = new ModalWindow(id, model);
        return modal;
    }

    protected MarkupContainer newOpenModalLink(String id, IModel<T> model) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                ModalDialogFragmentPanel.this.onShow(target);
            }
        };
    }

    protected void onClose(AjaxRequestTarget target) {
        this.getModalWindow().close(target);
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.modalWindow = this.newModalWindow("modal", this.getModel());
        componentArray[0] = this.modalWindow;
        this.add(componentArray);
        this.modalFragment = this.newModalFragment(this.modalWindow.getContentId(), "modalContent", (MarkupContainer)this, this.getModel());
        this.modalWindow.setContent((Component)this.modalFragment);
        this.modalFragment.add(new Component[]{this.newFragmentContent("fragmentContent", this.getModel())});
        Component[] componentArray2 = new Component[1];
        this.openModalLink = this.newOpenModalLink("openModal", this.getModel());
        componentArray2[0] = this.openModalLink;
        this.add(componentArray2);
    }

    protected void onShow(AjaxRequestTarget target) {
        target.prependJavaScript((CharSequence)WICKET_WINDOW_UNLOAD_CONFIRMATION_FALSE_JS);
        this.getModalWindow().show(target);
    }

    public ModalWindow getModalWindow() {
        return this.modalWindow;
    }

    public MarkupContainer getOpenModalLink() {
        return this.openModalLink;
    }
}

